var CACHE_SITE = 'Aklooo.com-pwa-v.1.1';
var urlsToCache = [
'./offline.html',
'./css/pwa.css',
'./js/pwa.js',
'./manifest.json',
'./img/pwa/pwa.svg',
'./img/pwa/512.png',
'./img/pwa/maskable_icon.png',
'./img/pwa/desc-1.png',
'./img/pwa/desc-2.png'
];
self.addEventListener('install', function(event) {
    self.skipWaiting();
    event.waitUntil(
        caches.open(CACHE_SITE)
        .then(function(cache) {
            return cache.addAll(urlsToCache, {cache: 'reload'});
        })
        );
});
self.addEventListener('activate', event => {
    var cacheKeeplist = [CACHE_SITE];
    self.clients.claim();
    event.waitUntil(
        caches.keys().then((keyList) => {
            return Promise.all(keyList.map((key) => {
                if (cacheKeeplist.indexOf(key) === -1) {
                    console.log('SW: Updated.');
                    return caches.delete(key);
                }
            }));
        })

        );
});
self.addEventListener("fetch", (event) => {
    if ((event.request.method != 'POST')) { 
        event.respondWith(
            (async () => {
                try {
                    const networkResponse = await fetch(event.request);
                    const putInCache = async (request, response) => {
                        const cache = await caches.open(CACHE_SITE);
                        await cache.put(event.request, response);
                    };
                    putInCache(event.request, networkResponse.clone());
                    return networkResponse;
                } catch (error) {
                    const cacheResponse = await caches.match(event.request);
                    if (cacheResponse) {
                        return cacheResponse;
                    }
                    const fallbackResponse = await caches.match('./offline.html');
                    if (fallbackResponse) {
                        return fallbackResponse;
                    }
                }
            })()
            );
    }
});