window.brainbuff = typeof window.brainbuff === 'undefined' ? {} : window.brainbuff;
window.brainbuff.PWA = typeof window.brainbuff.PWA === 'undefined' ? {} : window.brainbuff.PWA;

window.brainbuff.PWA.startEnviroment = () => {
	if ('serviceWorker' in navigator) {
		navigator.serviceWorker.register('./sw.js')
		.then(reg => console.log('SW: Registered. Scope: ', reg.scope))
		.catch(err => console.warn('SW: Error while registering. Error: ', err))
	}
	let pwa = true;
	if (pwa) {
		window.brainbuff.PWA.controller();
	}
};
window.brainbuff.PWA.controller = () => {
	let deferredPrompt;
	let html = `
	<div id="pwa-popup" class="overlay">
	<a href="#!" class="popup-close" title="Back"></a>
	<div class="popup small-popup">
	<a class="small-close" href="#!" title="Back"></a>
	<h2 class="popup-header">BrainBuff</h2>
	<div class="popup-body">
	<p id="pwa-message"></p>
	<button class="pwa-btn" id="pwa-install">Try now</button>
	</div>
	</div>
	</div>`;
	pwaHTML = document.createElement('div');
	pwaHTML.classList.add('pwa');
	pwaHTML.innerHTML = html;
	document.body.appendChild(pwaHTML);
	let installPopup = document.body.querySelector('#pwa-popup');
	let installMsg = document.body.querySelector('#pwa-message');
	let installBtn = document.body.querySelector('#pwa-install');
	const userAgent = window.navigator.userAgent.toLowerCase();
	const ios = /iphone|ipod|ipad/.test(userAgent);
	const safari = /safari/.test(userAgent);
	if (ios) {
		installPopup.style.display = 'block';
		if (safari) {
			installMsg.innerHTML = 'To install our PWA you must tap <svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 640 640"><path fill="currentColor" d="M128 320c0-35.2 28.8-64 64-64h256c35.2 0 64 28.8 64 64v256c0 35.2-28.8 64-64 64h-256c-35.2 0-64-28.8-64-64v-256zM192 320v256h256v-256h-64v-64h-128v64h-64zM288 122.56v389.44h64v-389.44l98.24 98.24 45.44-45.12-175.68-175.68-176 176 45.44 44.8 98.56-97.92z"></path></svg> in Safari and add our website to the home screen.';
			installBtn.remove();
		} else {
			installMsg.innerHTML = 'iOS only supports progressive web apps in the Safari browser.';
			installBtn.remove();
		}
	} else {
		installMsg.innerHTML = 'BrainBuff is designed to be used as a progressive web application (abbreviated PWA), which translates into a better user experience, want to try the PWA?';
	}
	if (installBtn) {
		window.addEventListener('beforeinstallprompt', (e) => {
			deferredPrompt = e;
			installPopup.style.display = 'block';
			installBtn.style.display = 'initial';
		});
		installBtn.addEventListener('click', async () => {
			if (deferredPrompt !== null && deferredPrompt !== 'undefined') {
				deferredPrompt.prompt();
				const { outcome } = await deferredPrompt.userChoice;
				if (outcome === 'accepted') {
					deferredPrompt = null;
					installMsg.innerHTML = 'Our pwa has been installed successfully.';
					installBtn.remove();
				}
			}
		});
	}
};
(function () {
	window.brainbuff.PWA.startEnviroment();
})();