<?php
    $categories = App\Models\Category::active()
        ->where('restaurant_id', Status::ADMIN_CATEGORIES)
        ->orderBy('sort_order')
        ->get();
?>

<section class="foods-area section-bg-two pt-70 pb-20">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="food-category-slider">
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="food-item text-center">
                            <a href="<?php echo e(route('category.foods', $category->slug)); ?>">
                                <div class="food-item-box">
                                    <div class="food-item-box__thumb">
                                        <img class="w-100"
                                            src="<?php echo e(getImage(getFilePath('category') . '/' . @$category->image, getFileSize('category'))); ?>"
                                            alt="img not found" />
                                    </div>
                                </div>
                            </a>
                            <h4 class="food-item__title">
                                <a href="<?php echo e(route('category.foods', $category->slug)); ?>"><?php echo e(__($category->name)); ?></a>
                            </h4>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php if(!app()->offsetExists('slick_script')): ?>
    <?php $__env->startPush('style-lib'); ?>
        <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/slick.css')); ?>">
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset($activeTemplateTrue . 'js/slick.min.js')); ?>"></script>
    <?php $__env->stopPush(); ?>

    <?php app()->offsetSet('slick_script',true) ?>
<?php endif; ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('.food-category-slider').slick({
                slidesToShow: 6,
                slidesToScroll: 3,
                autoplay: true,
                autoplaySpeed: 2000,
                speed: 1500,
                dots: false,
                arrows: true,
                prevArrow: '<button type="button" class="slick-prev service-nav-btn"><i class="las la-angle-left"></i></button>',
                nextArrow: '<button type="button" class="slick-next service-nav-btn"><i class="las la-angle-right"></i></button>',
                responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 5,
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 4,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 3,
                        }
                    },

                    {
                        breakpoint: 575,
                        settings: {
                            slidesToShow: 3,
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 3,
                        }
                    },
                    {
                        breakpoint: 375,
                        settings: {
                            slidesToShow: 2,
                        }
                    },
                ]
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/sections/category.blade.php ENDPATH**/ ?>