<?php $__env->startSection('content'); ?>
    <?php
        $kyc = getContent('kyc.content', true);
        $restaurant = authRestaurant();
    ?>

    <div class="notice"></div>

    <?php if(authRestaurant()->kv == Status::KYC_UNVERIFIED && authRestaurant()->kyc_rejection_reason): ?>
        <div class="dashboard-widget style-danger mb-4 d-flex align-items-center">
            <div class="dashboard-widget__icon flex-center me-3">
                <i class="las la-user-times"></i>
            </div>
            <div class="dashboard-widget__content">
                <h5 class="dashboard-widget__text"><?php echo app('translator')->get('KYC Documents Rejected'); ?></h5>
                <p class="dashboard-widget__number"><?php echo e(__(@$kyc->data_values->reject)); ?>

                    <a href="<?php echo e(route('restaurant.kyc.form')); ?>"><?php echo app('translator')->get('Click Here to Re-submit Documents'); ?></a>.
                </p>
                <p>
                    <?php echo app('translator')->get('You can'); ?>
                    <a href="<?php echo e(route('restaurant.kyc.data')); ?>"><?php echo app('translator')->get('view your KYC data'); ?></a>
                    <?php echo app('translator')->get('or'); ?>
                    <a href="javascript:void(0)" data-bs-toggle="modal"
                        data-bs-target="#kycRejectionReason"><?php echo app('translator')->get('see the reason for rejection'); ?></a>.
                </p>
            </div>
        </div>
    <?php elseif(authRestaurant()->kv == Status::KYC_UNVERIFIED): ?>
        <div class="dashboard-widget style-info mb-4 d-flex align-items-center">
            <div class="dashboard-widget__icon flex-center me-3">
                <i class="las la-user-check"></i>
            </div>
            <div class="dashboard-widget__content">
                <h5 class="dashboard-widget__text"><?php echo app('translator')->get('KYC Verification required'); ?></h5>
                <p class="dashboard-widget__number"><?php echo e(__(@$kyc->data_values->required)); ?>

                    <a href="<?php echo e(route('restaurant.kyc.form')); ?>"><?php echo app('translator')->get('Click Here to Submit Documents'); ?></a>
                </p>
            </div>
        </div>
    <?php elseif(authRestaurant()->kv == Status::KYC_PENDING): ?>
        <div class="dashboard-widget style-warning mb-4 d-flex align-items-center">
            <div class="dashboard-widget__icon flex-center me-3">
                <i class="las la-user-clock"></i>
            </div>
            <div class="dashboard-widget__content">
                <h5 class="dashboard-widget__text"><?php echo app('translator')->get('KYC Verification pending'); ?></h5>
                <p class="dashboard-widget__number"><?php echo e(__(@$kyc->data_values->pending)); ?>

                    <a href="<?php echo e(route('restaurant.kyc.data')); ?>"><?php echo app('translator')->get('See KYC Data'); ?></a>
                </p>
            </div>
        </div>
    <?php endif; ?>


    <div class="dashboard-widget-wrapper">
        <div class="row gy-4 justify-content-center">
            <div class="col-xxl-3 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-warning">
                    <a href="<?php echo e(route('restaurant.transactions')); ?>" class="link-to-go"></a>
                    <div class="dashboard-widget__icon flex-center">
                        <i class="las la-credit-card"></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text"><?php echo app('translator')->get('Balance'); ?></span>
                        <h5 class="dashboard-widget__number"><?php echo e(showAmount($widget['balance'])); ?>

                        </h5>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-success">
                    <a href="<?php echo e(route('restaurant.order.index')); ?>" class="link-to-go"></a>
                    <div class="dashboard-widget__icon flex-center">
                        <i class="las la-shopping-cart "></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text"><?php echo app('translator')->get('Total Orders'); ?></span>
                        <h5 class="dashboard-widget__number"><?php echo e($widget['total_orders']); ?></h5>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-primary">
                    <a href="<?php echo e(route('restaurant.order.active')); ?>" class="link-to-go"></a>
                    <div class="dashboard-widget__icon flex-center">
                        <i class="las la-shopping-cart "></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text"><?php echo app('translator')->get('Active Orders'); ?></span>
                        <h5 class="dashboard-widget__number"><?php echo e($widget['active_orders']); ?></h5>
                    </div>
                </div>
            </div>

            <div class="col-xxl-3 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-danger">
                    <a href="<?php echo e(route('restaurant.order.cancelled')); ?>" class="link-to-go"></a>
                    <div class="dashboard-widget__icon flex-center">
                        <i class="las la-times-circle "></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text"><?php echo app('translator')->get('Cancelled Orders'); ?></span>
                        <h5 class="dashboard-widget__number"><?php echo e($widget['cancelled_orders']); ?></h5>
                    </div>
                </div>
            </div>

            <div class="col-xxl-3 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-warning">
                    <a href="<?php echo e(route('restaurant.order.on.delivery')); ?>" class="link-to-go"></a>
                    <div class="dashboard-widget__icon flex-center">
                        <i class="las la-truck "></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text"><?php echo app('translator')->get('On Delivery Orders'); ?></span>
                        <h5 class="dashboard-widget__number"><?php echo e($widget['onDelivery_orders']); ?></h5>
                    </div>
                </div>
            </div>
            
            <div class="col-xxl-3 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-primary">
                    <a href="<?php echo e(route('restaurant.order.processing')); ?>" class="link-to-go"></a>
                    <div class="dashboard-widget__icon flex-center">
                        <i class="las la-spinner "></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text"><?php echo app('translator')->get('Processing Orders'); ?></span>
                        <h5 class="dashboard-widget__number"><?php echo e($widget['processing_orders']); ?></h5>
                    </div>
                </div>
            </div>


            
        </div>
    </div>
    <!-- Dashboard Card End -->

    <div class="dashboard-widget-wrapper">
        <h6 class="dashboard-widget-wrapper__title mb-3"><?php echo app('translator')->get('Sold Amount'); ?></h6>
        <div class="row gy-4 justify-content-center">
            <div class="col-xxl-4 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-warning">
                    <div class="dashboard-widget__icon flex-center">
                        7
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text"><?php echo app('translator')->get('Last 7 Days'); ?></span>
                        <h5 class="dashboard-widget__number">
                            <?php echo e(showAmount($widget['sold_last_7_days'])); ?></h5>
                    </div>
                </div>
            </div>
            <div class="col-xxl-4 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-success">
                    <div class="dashboard-widget__icon flex-center">
                        15
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text"><?php echo app('translator')->get('Last 15 Days'); ?></span>
                        <h5 class="dashboard-widget__number">
                            <?php echo e(showAmount($widget['sold_last_15_days'])); ?></h5>
                    </div>
                </div>
            </div>
            <div class="col-xxl-4 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-primary">
                    <div class="dashboard-widget__icon flex-center">
                        30
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text"><?php echo app('translator')->get('Last 30 Days'); ?></span>
                        <h5 class="dashboard-widget__number">
                            <?php echo e(showAmount($widget['sold_last_30_days'])); ?></h5>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row gy-4 justify-content-center mb-3">
        <div class="col-sm-6">
            <div class="card custom--card">
                <div class="card-body">
                    <h6 class="card-title"><?php echo app('translator')->get('Sales Report'); ?> (<?php echo app('translator')->get('Last 30 Days'); ?>)</h5>
                        <div id="apex-line"></div>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="card custom--card">
                <div class="card-body">
                    <h6 class="card-title"><?php echo app('translator')->get('Monthly Deposit & Withdraw Report'); ?> (<?php echo app('translator')->get('Last 12 Month'); ?>)</h5>
                        <div id="apex-bar-chart"> </div>
                </div>
            </div>
        </div>
    </div>

    <h6 class="mt-3 mb-0"><?php echo app('translator')->get('Latest Orders'); ?></h6>
    <div class="row gy-4 justify-content-center mt-1">
        <div class="col-12">
            <div class="dashboard-table">
                <table class="table table--responsive--lg">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('User'); ?></th>
                            <th><?php echo app('translator')->get('Address'); ?></th>
                            <th><?php echo app('translator')->get('Total Price'); ?></th>
                            <th><?php echo app('translator')->get('Payment Type'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $latestOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div>
                                        <?php echo e(__($order->user->fullname)); ?> <br />
                                        <small><a
                                                href="<?php echo e(route('restaurant.order.index', ['search' => $order->user->username])); ?>"><?php echo e(__($order->user->username)); ?></a></small>
                                    </div>
                                </td>
                                <td>
                                    <?php echo e(__(strLimit($order->address, 40))); ?>

                                </td>

                                <td>
                                    <div>
                                        <?php echo e(showAmount($order->total_price)); ?> <br>
                                        <small
                                            class="text--base"><?php echo e(showDateTime($order->created_at, 'd/m/y @ h A')); ?></small>
                                    </div>
                                </td>

                                <td>
                                    <?php echo $order->typeBadge ?>
                                </td>

                                <td>
                                    <?php echo $order->statusBadge ?>
                                    <?php if($order->status == Status::ORDER_DELIVERED): ?>
                                        <span class="infoIcon" data-toggle="tooltip" data-placement="top"
                                            title="<?php echo app('translator')->get('Payment will get dispersed once user confirms the order'); ?>">
                                            <i class="fas fa-info-circle"></i>
                                        </span>
                                    <?php endif; ?>
                                </td>

                                <td>
                                    <a href="<?php echo e(route('restaurant.order.details', $order->id)); ?>"
                                        class="btn btn--sm btn--success btn-outline--success btn--sm">
                                        <i class="la la-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted empty-message" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <?php if(authRestaurant()->kv == Status::KYC_UNVERIFIED && authRestaurant()->kyc_rejection_reason): ?>
        <div class="modal fade" id="kycRejectionReason">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo app('translator')->get('KYC Document Rejection Reason'); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p><?php echo e(authRestaurant()->kyc_rejection_reason); ?></p>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('assets/admin/js/vendor/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/vendor/chart.js.2.8.0.js')); ?>"></script>

    <script>
        (function($) {
            "use strict";

            // apex-bar chart
            var options = {
                series: [{
                    name: 'Total Deposit',
                    data: [
                        <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e(getAmount(@$depositsMonth->where('months', $month)->first()->depositAmount)); ?>,
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ]
                }, {
                    name: 'Total Withdraw',
                    data: [
                        <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e(getAmount(@$withdrawalMonth->where('months', $month)->first()->withdrawAmount)); ?>,
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ]
                }],
                chart: {
                    type: 'bar',
                    height: 450,
                    toolbar: {
                        show: false
                    }
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: '50%',
                        endingShape: 'rounded'
                    },
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    show: true,
                    width: 2,
                    colors: ['transparent']
                },
                xaxis: {
                    categories: <?php echo json_encode($months, 15, 512) ?>,
                },
                yaxis: {
                    title: {
                        text: "<?php echo e(__(gs('cur_sym'))); ?>",
                        style: {
                            color: '#7c97bb'
                        }
                    }
                },
                grid: {
                    xaxis: {
                        lines: {
                            show: false
                        }
                    },
                    yaxis: {
                        lines: {
                            show: false
                        }
                    },
                },
                fill: {
                    opacity: 1
                },
                tooltip: {
                    y: {
                        formatter: function(val) {
                            return "<?php echo e(__(gs('cur_sym'))); ?>" + val + " "
                        }
                    }
                }
            };
            var chart = new ApexCharts(document.querySelector("#apex-bar-chart"), options);
            chart.render();

            // apex-line chart
            var options = {
                chart: {
                    height: 450,
                    type: "area",
                    toolbar: {
                        show: false
                    },
                    dropShadow: {
                        enabled: true,
                        enabledSeries: [0],
                        top: -2,
                        left: 0,
                        blur: 10,
                        opacity: 0.08
                    },
                    animations: {
                        enabled: true,
                        easing: 'linear',
                        dynamicAnimation: {
                            speed: 1000
                        }
                    },
                },
                dataLabels: {
                    enabled: false
                },
                series: [{
                    name: "Monthly Sales",
                    data: [
                        <?php $__currentLoopData = $salesReport['date']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salesDate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e(@$sales->where('date', $salesDate)->first()->total_price ?? 0); ?>,
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ]
                }],
                fill: {
                    type: "gradient",
                    gradient: {
                        shadeIntensity: 1,
                        opacityFrom: 0.7,
                        opacityTo: 0.9,
                        stops: [0, 90, 100]
                    }
                },
                xaxis: {
                    categories: [
                        <?php $__currentLoopData = $salesReport['date']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salesDate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($salesDate); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ]
                },
                grid: {
                    padding: {
                        left: 5,
                        right: 5
                    },
                    xaxis: {
                        lines: {
                            show: false
                        }
                    },
                    yaxis: {
                        lines: {
                            show: false
                        }
                    },
                },
            };

            var chart = new ApexCharts(document.querySelector("#apex-line"), options);

            chart.render();

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'restaurant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/dashboard.blade.php ENDPATH**/ ?>