<?php
    $currentOrder = App\Models\Order::userOrders()
        ->whereIn('status', [Status::ORDER_PROCESSING, Status::ORDER_ON_DELIVERY])
        ->latest()
        ->first();

    if (request()->routeIs('restaurant.details')) {
        if (@$restaurant->id == @userInfo()['cart_restaurant_id']) {
            $cartUrl = 'javascript:void(0)';
        } else {
            $cartUrl = @userInfo()['cart_link'];
        }
    } else {
        $cartUrl = @userInfo()['cart_link'];
    }

    $cartCount = @userInfo()['cart_count'] ?? 0;
    $authenticatedUser = authenticatedUser();

?>

<div class="header-area">
    <div class="header-main" id="header-sticky">
        <div class="container custom-container">
            <div class="row align-items-center ">
                <div class="col-xl-2 col-lg-2 col-md-2 col-sm-3 col-12 d-flex justify-content-between">
                    <div class="logo">
                        <a href="<?php echo e(route('home')); ?>" class="logo-w"><img src="<?php echo e(siteLogo()); ?>" alt="logo-img"></a>
                    </div>
                    <div class="menu-bar d-sm-none">
                        <a class="side-toggle" href="javascript:void(0)">
                            <div class="bar-icon">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </a>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-4  d-none d-xl-block">
                    <div class="main-menu-wrapper">
                        <div class="main-menu-inner d-flex align-items-center ">
                            <div class="menumain">
                                <nav id="mobile-menu">
                                    <ul>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-10 col-md-10 col-sm-9 col-12 d-xl-block">
                    <div
                        class="header-area-right d-flex align-items-center justify-content-center justify-content-sm-end cart-menu-none">

                        <?php echo $__env->make($activeTemplate . 'partials.header.current_order', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <?php echo $__env->make($activeTemplate . 'partials.header.cart_favorite', [
                            'cartUrl' => $cartUrl,
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <div class="d-none d-lg-block">
                            <div class="header-area-right__featurs d-flex  align-items-center">
                                <div class="theme-switch-wrapper">
                                    <label class="theme-switch" for="checkbox2">
                                        <input type="checkbox" id="checkbox2" class="d-none">
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                                <?php echo $__env->make($activeTemplate . 'partials.header.language_box', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                        <div class="nav-right-profile d-none d-lg-block">
                            <ul class="prfile-menu">
                                <li>
                                    <?php echo $__env->make($activeTemplate . 'partials.header.user_profile_dropdown', [
                                        'authenticatedUser' => $authenticatedUser,
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            </ul>
                        </div>
                        <div class="menu-bar menu-bar-sm  d-xl-none">
                            <a class="side-toggle" href="javascript:void(0)">
                                <div class="bar-icon">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div
    class="header-area-right d-flex align-items-center justify-content-center justify-content-sm-end cart-menu d-block d-sm-none ">
    <?php echo $__env->make($activeTemplate . 'partials.header.current_order_mobile_view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make($activeTemplate . 'partials.header.cart_favorite', ['cartUrl' => $cartUrl], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<?php echo $__env->make($activeTemplate . 'partials.header.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/partials/user_header.blade.php ENDPATH**/ ?>