<?php $__env->startSection('panel'); ?>
    <div class="row mb-none-30 justify-content-center">
        <div class="col-xl-4 col-md-6 mb-30">
            <?php if($food->variations_count): ?>
                <div class="card b-radius--10 overflow-hidden box--shadow1 mt-2">
                    <div class="card-body">
                        <h5 class="mb-20 text-muted"><?php echo app('translator')->get('Variants'); ?></h5>
                        <div class="accordion custom--accordion">
                            <?php $__currentLoopData = @$food->variations ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="faqHeading<?php echo e($loop->iteration); ?>">
                                        <button class="accordion-button <?php if(!$loop->first): ?> collapsed <?php endif; ?>"
                                            type="button" data-bs-toggle="collapse"
                                            data-bs-target="#faqCollapse<?php echo e($loop->iteration); ?>"
                                            <?php if($loop->first): ?> aria-expanded="true"
                                            <?php else: ?>
                                            aria-expanded="false" <?php endif; ?>
                                            aria-controls="faqCollapse<?php echo e($loop->iteration); ?>">
                                            <span><?php echo e($variant->title); ?></span>
                                        </button>
                                    </h2>
                                    <div id="faqCollapse<?php echo e($loop->iteration); ?>"
                                        class="accordion-collapse collapse <?php if($loop->first): ?> show <?php endif; ?>"
                                        aria-labelledby="faqHeading<?php echo e($loop->iteration); ?>"
                                        data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <?php $__currentLoopData = @$variant->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="food-info-wrapper">
                                                    <div class="food-info-group">
                                                        <h6><?php echo app('translator')->get('Name'); ?>:</h6>
                                                        <p><?php echo e($item->name); ?></p>
                                                    </div>

                                                    <div class="food-info-group">
                                                        <h6><?php echo app('translator')->get('Price'); ?>:</h6>
                                                        <p><?php echo e(showAmount($item->price)); ?></p>
                                                    </div>
                                                </div>
                                                <?php if(!$loop->last): ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($food->addons_count): ?>
                <div class="card b-radius--10 overflow-hidden box--shadow1 mt-2">
                    <div class="card-body">
                        <h5 class="card-title  border-bottom mb-3 text-muted"><?php echo app('translator')->get('Addons'); ?></h5>
                        <?php $__currentLoopData = @$food->addons ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="food-info-wrapper">
                                <div class="food-info-group">
                                    <h6><?php echo app('translator')->get('Name'); ?>:</h6>
                                    <p><?php echo e($addon->name); ?></p>
                                </div>

                                <div class="food-info-group">
                                    <h6><?php echo app('translator')->get('Price'); ?>:</h6>
                                    <p><?php echo e(showAmount($addon->price)); ?></p>
                                </div>
                            </div>
                            <?php if(!$loop->last): ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>


        </div>
        <div
            <?php if(!$food->variations_count && !$food->addons_count): ?> class="col-xl-12 col-md-12 mb-30" <?php else: ?> class="col-xl-8 col-md-6 mb-30" <?php endif; ?>>
            <div class="card b-radius--10 overflow-hidden box--shadow1 mb-3">
                <div class="card-body">
                    <h5 class="card-title  border-bottom mb-3 text-muted"><?php echo app('translator')->get('Info'); ?></h5>
                    <div class="food-info-group">
                        <h6 for=""><?php echo app('translator')->get('Name'); ?>:</h6>
                        <p class="mb-3"><?php echo e($food->name); ?></p>
                    </div>
                    <div class="food-info-group">
                        <h6 for=""><?php echo app('translator')->get('Restaurant Name'); ?>:</h6>
                        <a
                            href="<?php echo e(route('admin.restaurants.detail', $food->restaurant->id)); ?>"><?php echo e($food->restaurant->restaurant_name); ?></a>
                    </div>
                    <div class="food-info-group">
                        <h6 for=""><?php echo app('translator')->get('Description'); ?>:</h6>
                        <p><?php echo e(@$food->short_description); ?></p>
                    </div>
                    <div class="food-info-group">
                        <h6 for=""><?php echo app('translator')->get('Price'); ?>:</h6>
                        <p><?php echo e(showAmount($food->price)); ?></p>
                    </div>
                    <div class="food-info-group">
                        <h6 for=""><?php echo app('translator')->get('Categories'); ?>:</h6>
                        <p>
                            <?php $__currentLoopData = $food->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e(@$category->name); ?> <?php if(!$loop->last): ?>
                                    ,
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </p>
                    </div>
                </div>
            </div>

            <div class="card b-radius--10 overflow-hidden box--shadow1 mb-3">
                <div class="card-body">
                    <h5 class="card-title border-bottom pb-2 text-muted"><?php echo app('translator')->get('Cover Photo'); ?></h5>
                    <div class="d-flex justify-content-center">
                        <img class="rounded-3"
                            src="<?php echo e(getImage(getFilePath('food') . '/' . $food->image, getFileSize('food'))); ?>"
                            alt="no image found">
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/admin/food/details.blade.php ENDPATH**/ ?>