<?php $__env->startSection('content'); ?>
    <div class="container py-70">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card custom--card">
                    <div class="card-body">
                        <form method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <!-- Restaurant Information -->
                            <h5 class="mb-4"><?php echo app('translator')->get('Restaurant Information'); ?> <i class="las la-hamburger text--base"></i></h5>
                            <div class="row">
                                <div class="form-group col-sm-12">
                                    <label class="form-label"><?php echo app('translator')->get('Restaurant Name'); ?></label>
                                    <input type="text" class="form-control form--control" name="restaurant_name"
                                        value="<?php echo e(@$restaurant->restaurant_name); ?>" required readonly>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('E-mail Address'); ?></label>
                                    <input class="form-control form--control" value="<?php echo e($restaurant->email); ?>" readonly>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('Mobile Number'); ?></label>
                                    <input class="form-control form--control" value="<?php echo e($restaurant->mobile); ?>" readonly>
                                </div>
                            </div>

                            <!-- Address Information -->
                            <h5 class="mt-5 mb-4"><?php echo app('translator')->get('Address Information'); ?> <i class="las la-map-marker-alt text--base"></i></h5>
                            <div class="row">
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('Address'); ?></label>
                                    <input type="text" class="form-control form--control" name="address"
                                        value="<?php echo e(@$restaurant->address); ?>">
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('State'); ?></label>
                                    <input type="text" class="form-control form--control" name="state"
                                        value="<?php echo e(@$restaurant->state); ?>">
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-sm-4">
                                    <label class="form-label"><?php echo app('translator')->get('Zip Code'); ?></label>
                                    <input type="text" class="form-control form--control" name="zip"
                                        value="<?php echo e(@$restaurant->zip); ?>">
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="form-label"><?php echo app('translator')->get('City'); ?></label>
                                    <input type="text" class="form-control form--control" name="city"
                                        value="<?php echo e(@$restaurant->city); ?>">
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="form-label" for="location"><?php echo app('translator')->get('Location'); ?></label>
                                    <select id="location" name="location"
                                        class="form-select form-control form--control select2-basic" required>
                                        <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($location->id); ?>"
                                                <?php echo e(old('location', @$restaurant->location_id) == $location->id ? 'selected' : ''); ?>>
                                                <?php echo e(__($location->name)); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <!-- Media Uploads -->
                            <h5 class="mt-5 mb-4"><?php echo app('translator')->get('Media Uploads'); ?> <i class="las la-image text--base"></i></h5>
                            <div class="row">
                                <div class="form-group col-12">
                                    <label>
                                        <?php echo app('translator')->get('Cover Image'); ?>
                                        <i class="las la-info-circle" data-toggle="tooltip" title="<?php echo app('translator')->get('Upload a cover image for your restaurant. This image will be displayed at the top of your restaurant details page.'); ?>"></i>
                                    </label>
                                    <?php if (isset($component)) { $__componentOriginaldbcc027cdd3569f61821c56d10b77c01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.image-uploader','data' => ['image' => ''.e(@$restaurant->cover_image).'','class' => 'w-100','type' => 'restaurantCover','required' => false,'id' => 'restaurantCover','name' => 'cover_image']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('image-uploader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['image' => ''.e(@$restaurant->cover_image).'','class' => 'w-100','type' => 'restaurantCover','required' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'id' => 'restaurantCover','name' => 'cover_image']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $attributes = $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $component = $__componentOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>
                                        <?php echo app('translator')->get('Thumbnail Image'); ?>
                                        <i class="las la-info-circle" data-toggle="tooltip" title="<?php echo app('translator')->get('Upload a thumbnail image that represents your restaurant in listings and previews.'); ?>"></i>
                                    </label>
                                    <?php if (isset($component)) { $__componentOriginaldbcc027cdd3569f61821c56d10b77c01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.image-uploader','data' => ['image' => ''.e(@$restaurant->cover_image_thumb).'','class' => 'w-100','type' => 'restaurantCoverThumb','required' => false,'id' => 'restaurantCoverThumb','name' => 'cover_image_thumb']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('image-uploader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['image' => ''.e(@$restaurant->cover_image_thumb).'','class' => 'w-100','type' => 'restaurantCoverThumb','required' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'id' => 'restaurantCoverThumb','name' => 'cover_image_thumb']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $attributes = $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $component = $__componentOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>
                                        <?php echo app('translator')->get('Profile Image'); ?>
                                        <i class="las la-info-circle" data-toggle="tooltip" title="<?php echo app('translator')->get('Upload a profile image for your restaurant, typically a restaurant logo.'); ?>"></i>
                                    </label>
                                    <?php if (isset($component)) { $__componentOriginaldbcc027cdd3569f61821c56d10b77c01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.image-uploader','data' => ['image' => ''.e(@$restaurant->profile_image).'','class' => 'w-100','type' => 'restaurantProfile','required' => false,'id' => 'restaurantProfile','name' => 'profile_image']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('image-uploader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['image' => ''.e(@$restaurant->profile_image).'','class' => 'w-100','type' => 'restaurantProfile','required' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'id' => 'restaurantProfile','name' => 'profile_image']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $attributes = $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $component = $__componentOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
                                </div>

                            </div>

                            <!-- Submit Button -->
                            <div class="form-group mb-0">
                                <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Submit'); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'restaurant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/profile_setting.blade.php ENDPATH**/ ?>