<?php
    $subscribe = getContent('subscribe.content', true);
    $contact_us = getContent('contact_us.content', true);
    $locations = App\Models\Location::active()->limit(8)->get();
    $categories = App\Models\Category::active()
        ->where('restaurant_id', Status::ADMIN_CATEGORIES)
        ->orderBy('sort_order')
        ->limit(8)
        ->get();
    $locationCount = $locations->count();
    $locationCurrentIndex = 0;

    $categoryCount = $categories->count();
    $categoryCurrentIndex = 0;

    $pages = App\Models\Page::where('tempname', $activeTemplate)
        ->where('is_default', Status::NO)
        ->get();
    $links = getContent('policy_pages.element');
    $authenticatedUser = authenticatedUser();
?>
<footer class="footer-area">
    <div class="footer-area-top pt-80 pb-80">
        <img src="<?php echo e(getImage($activeTemplateTrue . 'images/frame.png')); ?>" alt="img not found"
            class="footer-area-shape-one">
        <img src="<?php echo e(getImage($activeTemplateTrue . 'images/frame2.png')); ?>" alt="img not found"
            class="footer-area-shape-two">
        <div class="container">
            <div class="row gy-4">
                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6">
                    <div class="footer-widget">
                        <h4 class="footer-widget__title">
                            <?php echo app('translator')->get('Categories'); ?>
                        </h4>
                        <?php while($categoryCurrentIndex < $categoryCount): ?>
                            <ul class="footer-widget__link style-one">
                                <?php for($i = $categoryCurrentIndex; $i < min($categoryCurrentIndex + 4, $categoryCount); $i++): ?>
                                    <li><a
                                            href="<?php echo e(route('category.foods', $categories[$i]->slug)); ?>"><?php echo e(ucfirst(__($categories[$i]->name))); ?></a>
                                    </li>
                                <?php endfor; ?>
                            </ul>
                            <?php $categoryCurrentIndex += 4; ?>
                        <?php endwhile; ?>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6">
                    <div class="footer-widget footer-left-40">
                        <h4 class="footer-widget__title">
                            <?php echo app('translator')->get('Coverage Area'); ?>
                        </h4>
                        <?php while($locationCurrentIndex < $locationCount): ?>
                            <ul class="footer-widget__link style-one">
                                <?php for($i = $locationCurrentIndex; $i < min($locationCurrentIndex + 4, $locationCount); $i++): ?>
                                    <li><a href="javascript:void(0)"><?php echo e(ucfirst(__($locations[$i]->name))); ?></a>
                                    </li>
                                <?php endfor; ?>
                            </ul>
                            <?php $locationCurrentIndex += 4; ?>
                        <?php endwhile; ?>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6">
                    <div class="footer-widget footer-left-40">
                        <h4 class="footer-widget__title">
                            <?php echo app('translator')->get('Help'); ?>
                        </h4>
                        <ul class="footer-widget__link style-two">
                            <?php
                                $userLoggedIn = auth()->user();
                                $restaurantLoggedIn = auth()->guard('restaurant')->user();
                                $authenticated = $userLoggedIn || $restaurantLoggedIn;
                            ?>
                            <?php if(!$authenticated): ?>
                                <li>
                                    <a href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Login as User'); ?> </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('restaurant.login')); ?>"><?php echo app('translator')->get('Login as Restaurant'); ?> </a>
                                </li>
                            <?php else: ?>
                                <?php if($userLoggedIn): ?>
                                    <li>
                                        <a href="<?php echo e(route('restaurant.login')); ?>"><?php echo app('translator')->get('Login as Restaurant'); ?> </a>
                                    </li>
                                <?php endif; ?>
                                <?php if($restaurantLoggedIn): ?>
                                    <li>
                                        <a href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Login as User'); ?> </a>
                                    </li>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a href="<?php echo e(route('pages', [$data->slug])); ?>"> <?php echo e(__($data->name)); ?> </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a
                                        href="<?php echo e(route('policy.pages', [slug(@$link->data_values->title), $link->id])); ?>"><?php echo e(__(@$link->data_values->title)); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6">
                    <div class="footer-widget">
                        <h4 class="footer-widget__title">
                            <?php echo e(__(@$subscribe->data_values->heading)); ?>

                        </h4>
                        <p class="footer-widget__subtitle"><?php echo e(__(@$subscribe->data_values->description)); ?> </p>
                        <div class="footer-widget__newsletter">
                            <form action="main.php" class="subscribe-form" id="subscribe-form">
                                <input type="email" name="email" class="form-control form--control"
                                    placeholder="<?php echo app('translator')->get('Your email'); ?>...">
                                <button type="submit" class="btn subscribe-btn"><i
                                        class="las la-long-arrow-alt-right"></i></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="footer-bottom">
        <div class="container">
            <div class="row align-items-center text-center">
                <div class="col-12">
                    <div class="footer-bottom__left">
                        <p><?php echo e(__(@$contact_us->data_values->website_footer)); ?></p>
                        <?php
                            $socialLinks = getContent('social_links.element');
                        ?>
                        <ul class="social-list__footer">
                            <?php $__currentLoopData = $socialLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $socialLink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="social-list__item__footer">
                                    <a href="<?php echo e(@$socialLink->data_values->url); ?>"
                                        class="social-list__footer__link flex-center" target="_blank">
                                        <?php echo @$socialLink->data_values->social_icon ?>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>


<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('#subscribe-form').on('submit', function(e) {
                e.preventDefault();
                let formData = new FormData($(this)[0]);
                let $this = $(this);
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
                    },
                    url: "<?php echo e(route('subscribe')); ?>",
                    method: "POST",
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    beforeSend: function() {
                        $this.find('button[type=submit]').html(`
                        <span class="right-sidebar__button-icon">
                            <i class="las la-spinner la-spin"></i>
                        </span>`).attr('disabled', true);
                    },
                    complete: function(e) {
                        $this.find('button[type=submit]').html(
                            `<i class="las la-long-arrow-alt-right"></i>`
                        ).attr('disabled', false);
                    },
                    success: function(resp) {
                        if (resp.success) {
                            notify('success', resp.message);
                            $this.find('input[name=email]').val('')
                        } else {
                            notify('error', resp.message || resp.error);
                        }
                    }
                });
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/partials/footer.blade.php ENDPATH**/ ?>