<div class="restaurant">
    <div class="restaurant__thumb">
        <a href="<?php echo e(route('restaurant.details', $restaurant->slug)); ?>"><img
                src="<?php echo e(getImage(getFilePath('restaurantCoverThumb') . '/' . $restaurant->cover_image_thumb, getFileSize('restaurantCoverThumb'), coverThumb: true)); ?>"
                alt="img not found"></a>
        <button class="restaurant__thumb-icon <?php echo e(restaurantIsFavorite($restaurant)); ?>"
            data-url=<?php echo e(route('restaurant.favorite', $restaurant->id)); ?>>
            <i class="far fa-heart"></i>
        </button>
    </div>
    <div class="restaurant__info d-flex">
        <div class="restaurant__info-thumb">
            <a href="<?php echo e(route('restaurant.details', $restaurant->slug)); ?>"> <img
                    src="<?php echo e(getImage(getFilePath('restaurantProfile') . '/thumb_' . $restaurant->profile_image, getFileThumbSize('restaurantProfile'), $avatar = true)); ?>"
                    alt="img not found"></a>
        </div>
        <div class="restaurant__info-content">
            <h4 class="restaurant__info-content-title">
                <a
                    href="<?php echo e(route('restaurant.details', $restaurant->slug)); ?>"><?php echo e(__($restaurant->restaurant_name)); ?></a>
            </h4>
            <span class="restaurant__info-content-location">
                <i class="fas fa-map-marker-alt"></i><?php echo e(__(@$restaurant->location->name)); ?>

            </span>
            <div class="restaurant__info-content-meta d-flex align-items-center justify-content-between flex-wrap">
                <ul class="restaurant__info-content-meta-left">
                    <li><i class="las la-clock"></i><?php echo e($restaurant->delivery_time); ?> <?php echo app('translator')->get('Mins'); ?></li>
                    <li><i class="las la-biking"></i><?php echo e(showAmount($restaurant->delivery_charge)); ?>

                    </li>
                </ul>
                <div class="restaurant__info-content-meta-right text-end">
                    <span><i class="las la-star"></i></span> <span>(<?php echo e($restaurant->averageRating()); ?>.0)</span>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/braixses/aklooo.com/core/resources/views/components/restaurant.blade.php ENDPATH**/ ?>