<div class="sidebar-menu flex-between">
    <div class="sidebar-menu__inner">
        <span class="sidebar-menu__close d-lg-none d-block"><i class="las la-times"></i></span>
        <div class="sidebar-logo">
            <a href="<?php echo e(route('restaurant.home')); ?>" class="sidebar-logo__link"><img src="<?php echo e(siteLogo('dark')); ?>"
                    alt="img not found"></a>
        </div>

        <ul class="sidebar-menu-list">
            <li class="sidebar-menu-list__item <?php echo e(menuActive('restaurant.home')); ?>">
                <a href="<?php echo e(route('restaurant.home')); ?>" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-home"></i></span>
                    <span class="text"><?php echo app('translator')->get('Dashboard'); ?></span>
                </a>
            </li>

            <li class="sidebar-submenu-list__item <?php echo e(menuActive('restaurant.categories')); ?>">
                <a href="<?php echo e(route('restaurant.categories')); ?>" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-tags"></i></span>
                    <span class="text"><?php echo app('translator')->get('Category'); ?></span>
                </a>
            </li>

            <li class="sidebar-menu-list__item has-dropdown <?php echo e(menuActive('restaurant.food*')); ?>">
                <a href="javascript:void(0)" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-hamburger"></i></span>
                    <span class="text"><?php echo app('translator')->get('Food'); ?></span>
                </a>
                <div class="sidebar-submenu" <?php echo menuActive('restaurant.food*',4) ?>>
                    <ul class="sidebar-submenu-list">
                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('restaurant.food.index')); ?>">
                            <a href="<?php echo e(route('restaurant.food.index')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('All Foods'); ?></span>
                            </a>
                        </li>

                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('restaurant.food.overview')); ?>">
                            <a href="<?php echo e(route('restaurant.food.overview')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('Add Food'); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            <li class="sidebar-menu-list__item has-dropdown <?php echo e(menuActive('restaurant.order*')); ?>">
                <a href="javascript:void(0)" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-file-invoice"></i></span>
                    <span class="text"><?php echo app('translator')->get('Orders'); ?></span>
                    <?php if(@$ordersActiveCount): ?>
                        <span class="menu-badge pill bg--danger ms-auto">
                            <span class="notify-text"><?php echo e(@$ordersActiveCount); ?></span>
                        </span>
                    <?php endif; ?>
                </a>
                </a>
                <div class="sidebar-submenu" <?php echo menuActive('restaurant.order*',4) ?>>
                    <ul class="sidebar-submenu-list">
                        
                         <li class="sidebar-submenu-list__item <?php echo e(menuActive('restaurant.order.processing')); ?>">
                            <a href="<?php echo e(route('restaurant.order.processing')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('Processing Orders'); ?></span>
                                
                            </a>
                        </li>


                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('restaurant.order.active')); ?>">
                            <a href="<?php echo e(route('restaurant.order.active')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('Active Orders'); ?></span>
                                <span class="notify-text"><?php echo e(@$ordersActiveCount); ?></span>
                            </a>
                        </li>

                       
                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('restaurant.order.on.delivery')); ?>">
                            <a href="<?php echo e(route('restaurant.order.on.delivery')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('On Delivery Orders'); ?></span>
                            </a>
                        </li>

                       

                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('restaurant.order.completed')); ?>">
                            <a href="<?php echo e(route('restaurant.order.completed')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('Completed Orders'); ?></span>
                            </a>
                        </li>


                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('restaurant.order.cancelled')); ?>">
                            <a href="<?php echo e(route('restaurant.order.cancelled')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('Cancelled Orders'); ?></span>
                            </a>
                        </li>
                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('restaurant.order.index')); ?>">
                            <a href="<?php echo e(route('restaurant.order.index')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('All Orders'); ?></span>
                            </a>
                        </li>

                    </ul>
                </div>
            </li>

            <li class="sidebar-menu-list__item <?php echo e(menuActive('restaurant.reviews')); ?>">
                <a href="<?php echo e(route('restaurant.reviews')); ?>" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-star"></i></span>
                    <span class="text"><?php echo app('translator')->get('Reviews'); ?></span>
                </a>
            </li>

            <li class="sidebar-menu-list__item <?php echo e(menuActive('restaurant.delivery.setting')); ?>">
                <a href="<?php echo e(route('restaurant.delivery.setting')); ?>" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-shopping-cart"></i></span>
                    <span class="text"><?php echo app('translator')->get('Delivery'); ?></span>
                </a>
            </li>

            <li class="sidebar-menu-list__item has-dropdown <?php echo e(menuActive('restaurant.deposit.*')); ?>">
                <a href="javascript:void(0)" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-file-invoice-dollar"></i></span>
                    <span class="text"><?php echo app('translator')->get('Deposit'); ?></span>
                </a>
                <div class="sidebar-submenu" <?php echo menuActive('restaurant.deposit.*',4) ?>>
                    <ul class="sidebar-submenu-list">
                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('restaurant.deposit.index')); ?>">
                            <a href="<?php echo e(route('restaurant.deposit.index')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('Deposit Now'); ?></span>
                            </a>
                        </li>
                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('restaurant.deposit.history')); ?>">
                            <a href="<?php echo e(route('restaurant.deposit.history')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('Deposit History'); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            

            <li class="sidebar-menu-list__item <?php echo e(menuActive('restaurant.transactions')); ?>">
                <a href="<?php echo e(route('restaurant.transactions')); ?>" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-file-invoice-dollar"></i></span>
                    <span class="text"><?php echo app('translator')->get('Transactions'); ?></span>
                </a>
            </li>

            <li class="sidebar-menu-list__item">
                <a href="<?php echo e(route('restaurant.logout')); ?>" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-sign-out-alt"></i></span>
                    <span class="text"><?php echo app('translator')->get('Logout'); ?></span>
                </a>
            </li>
        </ul>
    </div>

</div>
<?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/partials/sidenav.blade.php ENDPATH**/ ?>