<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9">
                <?php echo $__env->make($activeTemplate . 'restaurant.partials.food_progress_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
        <div class="card custom--card mt-5 mb-3">
            <div class="card-body">
                <form id="foodForm">
                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <div class="category">
                                <div class="dragndrop old">
                                    <div class="form-group mb-0">
                                        <div class="input-images"></div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="d-flex justify-content-between flex-wrap gap-3">
            <small class="mt-3 text-muted"> <?php echo app('translator')->get('Supported Files'); ?>: <b><?php echo app('translator')->get('.png, .jpg, .jpeg'); ?>.</b> <?php echo app('translator')->get('Image will be resized into'); ?>
                <b><?php echo e(getFileSize('food')); ?></b> px </small>
            <?php if(!request()->routeIs('restaurant.food.publish')): ?>
                <button class="btn btn--base" id="saveAndContinue" type="button">
                    <?php echo app('translator')->get('Save & Continue'); ?> <i class="las la-angle-right"></i>
                </button>
            <?php endif; ?>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/restaurant/css/image-uploader.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/restaurant/js/image-uploader.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .custom--card .card-body {
            padding: 10px 15px
        }

        .category .dragndrop .form-label-two {
            margin-bottom: 10px;
        }

        .image-uploader {
            border: none !important;
        }

        .image-uploader .uploaded {
            padding: 0 !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('.input-images').imageUploader({

                <?php if(isset($food->image)): ?>
                    preloaded: [{
                        id: '<?php echo e($food->image); ?>',
                        src: '<?php echo e(getImage(getFilePath('food') . '/' . $food->image, getFileSize('food'))); ?>'
                    }],
                <?php endif; ?>

                imagesInputName: 'image',
                preloadedInputName: 'old',
                maxFiles: 1
            });

            //Ajax
            $('#saveAndContinue').on('click', function() {
                var btn = $(this);
                var btnName = `<?php echo app('translator')->get('Save & Continue'); ?> <i class="las la-angle-right"></i>`;

                //store
                var formData = new FormData($('#foodForm')[0]);
                var url = '<?php echo e(route('restaurant.food.store.image', @$food->id ?? '')); ?>';
                var token = '<?php echo e(csrf_token()); ?>';
                formData.append('_token', token);


                $.ajax({
                    url: url,
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        var btnAfterSubmit =
                            `<div class="spinner-border"></div> <?php echo app('translator')->get('Saving'); ?>...`;
                        btn.html(btnAfterSubmit);
                        btn.attr('disabled', true);
                    },
                    complete: function(e) {
                        btn.html(btnName);
                        btn.removeAttr('disabled');
                    },
                    success: function(response) {
                        if (response.success) {
                            if (!response.is_update) {
                                window.location.href = response.redirect_url
                            } else {
                                notify('success', `<?php echo app('translator')->get('Food image updated successfully'); ?>`);
                                btn.html(btnName);
                                btn.removeAttr('disabled');
                            }
                        } else {
                            notify('error', response.message);
                            btn.html(btnName);
                            btn.removeAttr('disabled');
                        }
                    },
                    error: function(xhr, status, error) {
                        notify('error', error);
                        btn.html(btnName);
                        btn.removeAttr('disabled');
                    }
                });
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'restaurant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/food/image.blade.php ENDPATH**/ ?>