<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Restaurant'); ?></th>
                                    <th><?php echo app('translator')->get('Foods'); ?></th>
                                    <th><?php echo app('translator')->get('Email-Phone'); ?></th>
                                    <th><?php echo app('translator')->get('Location'); ?></th>
                                    <th><?php echo app('translator')->get('Joined At'); ?></th>
                                    <th><?php echo app('translator')->get('Balance'); ?></th>
                                    <th><?php echo app('translator')->get('Featured'); ?></th> <!-- Added Featured Column -->
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $restaurants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $restaurant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div class="user">
                                                <div class="thumb me-2">
                                                    <img src="<?php echo e(getImage(getFilePath('restaurantProfile') . '/' . @$restaurant->profile_image, getFileSize('restaurantProfile'))); ?>"
                                                        alt="<?php echo e(__($restaurant->restaurant_name)); ?>" class="plugin_bg">
                                                </div>
                                                <div>
                                                    <span class="fw-bold"><?php echo e($restaurant->restaurant_name); ?></span><br>
                                                    <span class="small">
                                                        <a href="<?php echo e(route('admin.restaurants.detail', $restaurant->id)); ?>">
                                                            <span>@</span><?php echo e($restaurant->username); ?>

                                                        </a>
                                                    </span>
                                                </div>
                                            </div>
                                        </td>

                                        <td>
                                            <a href="<?php echo e(route('admin.foods.index', ['search' => $restaurant->restaurant_name])); ?>"
                                                title="View Foods">
                                                <?php echo e($restaurant->foods_count); ?>

                                            </a>
                                        </td>
                                        <td><?php echo e($restaurant->email); ?><br><?php echo e($restaurant->mobile); ?></td>
                                        <td>
                                            <span class="fw-bold"><?php echo e(__(@$restaurant->location->name)); ?></span>
                                        </td>
                                        <td>
                                            <?php echo e(showDateTime($restaurant->created_at)); ?> <br>
                                            <?php echo e(diffForHumans($restaurant->created_at)); ?>

                                        </td>
                                        <td>
                                            <span class="fw-bold">
                                                <?php echo e(showAmount($restaurant->balance)); ?>

                                            </span>
                                        </td>
                                        <td><?php echo $restaurant->featuredBadge ?></td>
                                        <td>
                                            <div class="button--group">
                                                <?php if($restaurant->is_featured): ?>
                                                    <button class="btn btn-sm btn-outline--danger confirmationBtn"
                                                        data-question="<?php echo app('translator')->get('Are you sure not to feature this restaurant?'); ?>"
                                                        data-action="<?php echo e(route('admin.restaurants.featured', $restaurant->id)); ?>">
                                                        <i class="la la-eye-slash"></i> <?php echo app('translator')->get('Unfeature'); ?>
                                                    </button>
                                                <?php else: ?>
                                                    <button class="btn btn-sm btn-outline--success confirmationBtn"
                                                        data-question="<?php echo app('translator')->get('Are you sure to feature this restaurant?'); ?>"
                                                        data-action="<?php echo e(route('admin.restaurants.featured', $restaurant->id)); ?>">
                                                        <i class="la la-eye"></i> <?php echo app('translator')->get('Feature'); ?>
                                                    </button>
                                                <?php endif; ?>
                                                <a href="<?php echo e(route('admin.restaurants.detail', $restaurant->id)); ?>"
                                                    class="btn btn-sm btn-outline--primary">
                                                    <i class="las la-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                                                </a>
                                                <?php if(request()->routeIs('admin.restaurants.kyc.pending')): ?>
                                                    <a href="<?php echo e(route('admin.restaurants.kyc.details', $restaurant->id)); ?>"
                                                        target="_blank" class="btn btn-sm btn-outline--dark">
                                                        <i class="las la-user-check"></i><?php echo app('translator')->get('KYC Data'); ?>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <?php if($restaurants->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($restaurants)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'Username / Email']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'Username / Email']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/admin/restaurants/list.blade.php ENDPATH**/ ?>