<?php
    if (session()->get('theme')) {
        $theme = session()->get('theme');
    } else {
        $theme = 'light';
    }
?>

<!doctype html>
<html lang="<?php echo e(config('app.locale')); ?>" itemscope itemtype="http://schema.org/WebPage" data-theme="<?php echo e($theme); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> <?php echo e(gs()->siteName(__($pageTitle))); ?></title>
    <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <link href="<?php echo e(asset('assets/global/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/global/css/all.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/line-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/meanmenu.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/main.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/custom.css')); ?>">
    <?php echo $__env->yieldPushContent('style-lib'); ?>
    <?php echo $__env->yieldPushContent('style'); ?>
    <link rel="stylesheet"
        href="<?php echo e(asset($activeTemplateTrue . 'css/color.php')); ?>?color=<?php echo e(gs('base_color')); ?>&secondColor=<?php echo e(gs('secondary_color')); ?>">
        <meta name="color-scheme" content="dark light">
<meta name="theme-color" content="#e56b1f">
<meta name="mobile-web-app-capable" content="yes">
<meta name="application-name" content="Aklooo.com">
<link rel="icon" href="./storage/site/favicon.png">
<link rel="stylesheet" href="./css/pwa.css">
<link rel="stylesheet" href="/css/store.css">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black">
<link rel="manifest" href="./manifest.json">

</head>
<?php echo loadExtension('google-analytics') ?>

<body>
    <div class="overlay"></div>
    <a href="javascript::void(0)" class="scrollToTop"><i class="las la-chevron-up"></i></a>
    <div class="preloader">
        <div class="preloader__inner">
            <img src="<?php echo e(siteLogo('dark')); ?>" class="preloader-logo" alt="image" />
            <img src="<?php echo e(sitePreloader()); ?>" class="preloader-icon" alt="img not found" />
        </div>
    </div>
    <div class="sidebar-overlay"></div>

    <?php echo $__env->yieldPushContent('fbComment'); ?>
    <?php echo $__env->yieldContent('panel'); ?>
    <?php echo $__env->make($activeTemplate . 'partials.cart_login_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Optional JavaScript -->
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="<?php echo e(asset('assets/global/js/jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/meanmenu.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('script-lib'); ?>

    <script src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/main.js')); ?>"></script>
    <?php echo loadExtension('tawk-chat') ?>


    <?php if(gs('pn')): ?>
        <?php echo $__env->make('partials.push_script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <?php echo $__env->make('partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('script'); ?>
    <script>
        (function($) {
            "use strict";

            $(document).ready(function() {
                $('.select2-basic').select2();

                $(document).ready(function() {
                    $(".cart-btn").on("click", function() {
                        var cartCount = parseInt($(".cart-btn .cart-count").text());
                    });
                });

                const toggleSwitch = $('.theme-switch input[type="checkbox"]');
                const currentTheme = localStorage.getItem("theme");

                if (currentTheme) {
                    $("html").attr("data-theme", currentTheme);

                    if (currentTheme === "dark") {
                        toggleSwitch.prop("checked", true);
                    }
                }

                toggleSwitch.change(function(e) {
                    var mode;
                    if ($(this).prop("checked")) {
                        mode = "dark";
                    } else {
                        mode = "light";
                    }

                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
                        },
                        url: "<?php echo e(route('change.theme')); ?>",
                        method: 'POST',
                        data: {
                            mode
                        },
                        dataType: 'json',
                        success: function(resp) {
                            if (resp.success) {
                                $("html").attr("data-theme", mode);
                                localStorage.setItem("theme", mode);
                                notify('success', resp.message);
                            } else {
                                notify('error', resp.message || resp.error);
                            }
                        },
                        error: function(xhr, status, error) {
                            notify('error', error);
                        }
                    });

                });

                $(function() {
                    $('[data-toggle="tooltip"]').tooltip()
                })

            });

            if (window.innerWidth <= 1200) {
                if ($('#carts').length) {
                    $('#carts').removeAttr('id');
                }
            }


            $('.cart-btn').on('click', function(e) {
                e.preventDefault();
                $('.your-cart.your-cart-two').toggleClass('active');
                $(".sidebar-overlay").addClass("show");
            })


            // Click event for plus button
            $(document).on('click', ".modal__product-qty__increment", function(e) {
                e.preventDefault();
                var currentVal = parseInt($('.modal__product-qty__value').val());
                if (!isNaN(currentVal)) {
                    $('.modal__product-qty__value').val(currentVal + 1);
                }
                $('.modal__product-qty__value').change();
            });

            // Click event for minus button
            $(document).on('click', ".modal__product-qty__decrement", function(e) {
                e.preventDefault();
                var currentVal = parseInt($('.modal__product-qty__value').val());
                if (!isNaN(currentVal) && currentVal > 1) {
                    $('.modal__product-qty__value').val(currentVal - 1);
                }
                $('.modal__product-qty__value').change();
            });

            // Change event for input field
            $(document).on('change', ".modal__product-qty__value", function() {
                var val = $(this).val();
                if (val < 1 || isNaN(val)) {
                    $(this).val(1);
                }
            });

            //cart quantity change
            $(document).on('change', ".cart-quantity", function(e) {
                var value = e.target.value;
                if (value < 0) {
                    $(this).val(1);
                    value = e.target.value;
                }
                changeCartQuantity($(this).data('id'), value, null);
            });

            $(document).on('click', ".cart-quantity-btn", function(e) {
                changeCartQuantity($(this).data('id'), null, $(this).data('type'));
            });

            function changeCartQuantity(cartId, quantity, type) {
                //store
                var formData = new FormData();
                var url = '<?php echo e(route('food.cart.quantity')); ?>';
                var token = '<?php echo e(csrf_token()); ?>';
                formData.append('_token', token);
                formData.append('cartId', cartId);
                quantity && formData.append('quantity', quantity);
                type && formData.append('type', type);

                $.ajax({
                    url: url,
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        if (response.success) {
                            notify('success', `<?php echo app('translator')->get('Item updated in cart'); ?>`);
                            $('#cart').html(response.view)
                            $('.cart-btn-amount.cart-count').text(response.cart_count)
                        } else {
                            notify('error', response.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        notify('error', error);
                    }
                });
            }

        })(jQuery);
    </script>
	<script>
  if ('serviceWorker' in navigator) {
    navigator.serviceWorker.register('/sw.js')
      .then(() => console.log('✅ Service Worker مسجل'))
      .catch((err) => console.error('❌ فشل تسجيل Service Worker', err));
  }
</script>
<script>
  let deferredPrompt;

  window.addEventListener('beforeinstallprompt', (e) => {
    // منع البانر التلقائي
    e.preventDefault();
    deferredPrompt = e;

    // إظهار زر التثبيت
    const installBtn = document.getElementById('install-btn');
    if (installBtn) {
      installBtn.style.display = 'block';

      installBtn.addEventListener('click', () => {
        // أخفاء الزر
        installBtn.style.display = 'none';

        // عرض البانر
        deferredPrompt.prompt();

        // التعامل مع نتيجة المستخدم
        deferredPrompt.userChoice.then((choiceResult) => {
          if (choiceResult.outcome === 'accepted') {
            console.log('✅ المستخدم وافق على التثبيت');
          } else {
            console.log('❌ المستخدم رفض التثبيت');
          }
          deferredPrompt = null;
        });
      });
    }
  });
</script>
<!-- زر التثبيت -->
<button id="install-btn" style="display: none; position: fixed; top: 130px; right: 20px; padding: 10px 15px; background-color: #ff7f00; color: white; border: none; border-radius: 5px; z-index: 999;">
  📲 تثبيت التطبيق
</button>
</body>

</html>
<?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/layouts/app.blade.php ENDPATH**/ ?>