<?php
    $categories = App\Models\Category::active()
        ->featured()
        ->whereHas('foods', function ($query) {
            $query->whereHas('restaurant', function ($query) {
                $query->active();
            });
        })
        ->with('foods', 'foods.restaurant')
        ->orderBy('sort_order')
        ->get();
?>

<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="popular-foods-area section-bg-two pt-40 pb-40">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="section-common pb-20 d-flex align-items-center justify-content-between">
                        <h4 class="section-title"><?php echo e(__($category->name)); ?></h4>
                        <a href="<?php echo e(route('category.foods', $category->slug)); ?>" class="btn btn--base btn--sm"> <?php echo app('translator')->get('View All'); ?>
                            <span class="section-icon"><i class="la la-arrow-right"></i></span> </a>
                    </div>
                </div>
            </div>
            <div class="popular-foods-wrapper">
                <div class="row gy-4">
                    <?php $__currentLoopData = $category->foods->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $food): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-4 col-md-6 col-sm-6 col--xm-6">
                            <?php if (isset($component)) { $__componentOriginal22c73ba8f85811a30cbeee26dcdccf02 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal22c73ba8f85811a30cbeee26dcdccf02 = $attributes; } ?>
<?php $component = App\View\Components\Food::resolve(['food' => $food] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('food'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Food::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['isSection' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal22c73ba8f85811a30cbeee26dcdccf02)): ?>
<?php $attributes = $__attributesOriginal22c73ba8f85811a30cbeee26dcdccf02; ?>
<?php unset($__attributesOriginal22c73ba8f85811a30cbeee26dcdccf02); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal22c73ba8f85811a30cbeee26dcdccf02)): ?>
<?php $component = $__componentOriginal22c73ba8f85811a30cbeee26dcdccf02; ?>
<?php unset($__componentOriginal22c73ba8f85811a30cbeee26dcdccf02); ?>
<?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/sections/food_categories.blade.php ENDPATH**/ ?>