<?php $__env->startSection('content'); ?>
    <div class="container py-70">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="card custom--card">
                    <div class="card-body">
                        <form method="POST" action="<?php echo e(route('restaurant.data.submit')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <!-- Restaurant Details -->
                            <h5 class="mt-4 mb-4"><?php echo app('translator')->get('Restaurant Details'); ?> <i class="las la-utensils text--base"></i></h5>
                            <div class="row">
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('Restaurant Name'); ?></label>
                                    <input type="text" class="form-control form--control" name="restaurant_name"
                                        value="<?php echo e(old('restaurant_name')); ?>" required>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('Username'); ?></label>
                                    <input type="text" class="form-control form--control checkUser" name="username"
                                        value="<?php echo e(old('username')); ?>">
                                    <small class="text--danger usernameExist"></small>
                                    <small class="form-text text-muted"><?php echo app('translator')->get('Username will be used for login and identification'); ?></small>
                                </div>
                            </div>

                            <div class="row mt-3">
                                <div class="form-group col-sm-12">
                                    <label class="form-label"><?php echo app('translator')->get('Address'); ?></label>
                                    <input type="text" class="form-control form--control" name="address"
                                        value="<?php echo e(old('address')); ?>">
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="form-label"><?php echo app('translator')->get('State'); ?></label>
                                    <input type="text" class="form-control form--control" name="state"
                                        value="<?php echo e(old('state')); ?>">
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="form-label"><?php echo app('translator')->get('Zip Code'); ?></label>
                                    <input type="text" class="form-control form--control" name="zip"
                                        value="<?php echo e(old('zip')); ?>">
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="form-label"><?php echo app('translator')->get('City'); ?></label>
                                    <input type="text" class="form-control form--control" name="city"
                                        value="<?php echo e(old('city')); ?>">
                                </div>
                            </div>

                            <!-- Service Information -->
                            <h5 class="mt-4 mb-4"><?php echo app('translator')->get('Service Information'); ?> <i class="las la-truck text--base"></i></h5>
                            <div class="row">
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('Delivery Time'); ?></label>
                                    <div class="input-group">
                                        <input type="number" class="form-control form--control" name="delivery_time"
                                            value="<?php echo e(old('delivery_time')); ?>" required>
                                        <div class="input-group-text"><?php echo app('translator')->get('Minutes'); ?></div>
                                    </div>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('Delivery Charge'); ?></label>
                                    <div class="input-group">
                                        <input type="number" class="form-control form--control" name="delivery_charge"
                                            value="<?php echo e(old('delivery_charge')); ?>" required>
                                        <div class="input-group-text"><?php echo e(gs('cur_sym')); ?></div>
                                    </div>
                                </div>
                            </div>

                            <!-- Media -->
                            <h5 class="mt-4 mb-4"><?php echo app('translator')->get('Media'); ?> <i class="las la-camera text--base"></i></h5>
                            <div class="row">
                                <div class="form-group col-12">
                                    <label>
                                        <?php echo app('translator')->get('Cover Image'); ?>
                                        <i class="las la-info-circle" data-toggle="tooltip" title="<?php echo app('translator')->get('Upload a cover image for your restaurant. This image will be displayed at the top of your restaurant details page.'); ?>"></i>
                                    </label>
                                    <?php if (isset($component)) { $__componentOriginaldbcc027cdd3569f61821c56d10b77c01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.image-uploader','data' => ['class' => 'w-100','type' => 'restaurantCover','required' => false,'id' => 'restaurantCover','name' => 'cover_image']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('image-uploader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-100','type' => 'restaurantCover','required' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'id' => 'restaurantCover','name' => 'cover_image']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $attributes = $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $component = $__componentOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>
                                        <?php echo app('translator')->get('Thumbnail Image'); ?>
                                        <i class="las la-info-circle" data-toggle="tooltip" title="<?php echo app('translator')->get('Upload a thumbnail image that represents your restaurant in listings and previews.'); ?>"></i>
                                    </label>
                                    <?php if (isset($component)) { $__componentOriginaldbcc027cdd3569f61821c56d10b77c01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.image-uploader','data' => ['class' => 'w-100','type' => 'restaurantCoverThumb','required' => false,'id' => 'restaurantCoverThumb','name' => 'cover_image_thumb']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('image-uploader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-100','type' => 'restaurantCoverThumb','required' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'id' => 'restaurantCoverThumb','name' => 'cover_image_thumb']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $attributes = $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $component = $__componentOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>
                                        <?php echo app('translator')->get('Profile Image'); ?>
                                        <i class="las la-info-circle" data-toggle="tooltip" title="<?php echo app('translator')->get('Upload a profile image for your restaurant, typically a restaurant logo.'); ?>"></i>
                                    </label>
                                    <?php if (isset($component)) { $__componentOriginaldbcc027cdd3569f61821c56d10b77c01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.image-uploader','data' => ['class' => 'w-100','type' => 'restaurantProfile','required' => false,'id' => 'restaurantProfile','name' => 'profile_image']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('image-uploader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-100','type' => 'restaurantProfile','required' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'id' => 'restaurantProfile','name' => 'profile_image']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $attributes = $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $component = $__componentOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
                                </div>


                                <!-- Submit Button -->
                                <div class="form-group mb-0">
                                    <button type="submit" class="btn btn--base w-100">
                                        <?php echo app('translator')->get('Submit'); ?>
                                    </button>
                                </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .footer-area {
            display: none
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            $('.checkUser').on('focusout', function(e) {
                var value = $(this).val();
                var name = $(this).attr('name');
                checkUser(value, name);
            });

            function checkUser(value, name) {
                var url = '<?php echo e(route('restaurant.checkUser')); ?>';
                var token = '<?php echo e(csrf_token()); ?>';

                if (name == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    };
                }

                $.post(url, data, function(response) {
                    if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.field} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            }
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/restaurant_data.blade.php ENDPATH**/ ?>