<?php
    $popularRestaurant = getContent('popular_restaurant.content', true);
    $restaurants = App\Models\Restaurant::active()
        ->whereHas('foods')
        ->with('location', 'reviews')
        ->featured()
        ->with('location');
    $restaurants = sortRestaurants($restaurants);
    $showAllBtn = $restaurants->count() > 8;
    $restaurants = $restaurants->take(8);
?>

<section class="nearby-restaurant-area section-bg-two pt-40 pb-80">
    <img class="nearby-restaurant-shape-2" src="<?php echo e(getImage($activeTemplateTrue . 'images/food-shape-2.png')); ?>"
        alt="img not found">
    <img class="nearby-restaurant-shape-dark" src="<?php echo e(getImage($activeTemplateTrue . 'images/food-shape-dark.png')); ?>"
        alt="img not found">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="section-common pb-20 d-flex align-items-center justify-content-between">
                    <h4 class="section-title">
                        <?php echo e(__(@$popularRestaurant->data_values->heading)); ?>

                    </h4>
                    <?php if($showAllBtn): ?>
                        <a href="<?php echo e(route('popular.restaurants')); ?>" class="btn btn--base btn--sm"> <?php echo app('translator')->get('View All'); ?> <span
                                class="section-icon"><i class="la la-arrow-right"></i></span> </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="nearby-restaurant">
            <div class="row gy-4">
                <?php $__currentLoopData = $restaurants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $restaurant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col--xm-6">
                        <?php if (isset($component)) { $__componentOriginalfd767bbaafc668b79b7c0622527faddd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfd767bbaafc668b79b7c0622527faddd = $attributes; } ?>
<?php $component = App\View\Components\Restaurant::resolve(['restaurant' => $restaurant] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('restaurant'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Restaurant::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfd767bbaafc668b79b7c0622527faddd)): ?>
<?php $attributes = $__attributesOriginalfd767bbaafc668b79b7c0622527faddd; ?>
<?php unset($__attributesOriginalfd767bbaafc668b79b7c0622527faddd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfd767bbaafc668b79b7c0622527faddd)): ?>
<?php $component = $__componentOriginalfd767bbaafc668b79b7c0622527faddd; ?>
<?php unset($__componentOriginalfd767bbaafc668b79b7c0622527faddd); ?>
<?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/sections/popular_restaurant.blade.php ENDPATH**/ ?>