<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="show-filter mb-3 text-end">
                <button type="button" class="btn btn-outline--primary showFilterBtn btn-sm"><i class="las la-filter"></i>
                    <?php echo app('translator')->get('Filter'); ?></button>
            </div>
            <div class="card responsive-filter-card mb-4">
                <div class="card-body">
                    <form>
                        <div class="d-flex flex-wrap gap-4">
                            <!-- Username Filter -->
                            <div class="flex-grow-1">
                                <label><?php echo app('translator')->get('Username'); ?></label>
                                <input type="search" name="username" value="<?php echo e(request()->username); ?>"
                                    class="form-control">
                            </div>
                            <!-- Restaurant Name Filter -->
                            <div class="flex-grow-1">
                                <label><?php echo app('translator')->get('Restaurant Name'); ?></label>
                                <input type="search" name="restaurant_name" value="<?php echo e(request()->restaurant_name); ?>"
                                    class="form-control">
                            </div>
                            <!-- Payment Type Filter -->
                            <div class="flex-grow-1">
                                <label><?php echo app('translator')->get('Payment Type'); ?></label>
                                <select name="payment_type" class="form-control select2"
                                    data-minimum-results-for-search="-1">
                                    <option value=""><?php echo app('translator')->get('All'); ?></option>
                                    <option value="<?php echo e(Status::PAYMENT_CASH_ON_DELIVERY); ?>" <?php if(request()->payment_type == Status::PAYMENT_CASH_ON_DELIVERY): echo 'selected'; endif; ?>>
                                        <?php echo app('translator')->get('Cash on Delivery'); ?></option>
                                    <option value="<?php echo e(Status::PAYMENT_ONLINE_PAYMENT); ?>" <?php if(request()->payment_type == Status::PAYMENT_ONLINE_PAYMENT): echo 'selected'; endif; ?>>
                                        <?php echo app('translator')->get('Online Payment'); ?></option>
                                </select>
                            </div>
                            <!-- Status Filter -->
                            <div class="flex-grow-1">
                                <label><?php echo app('translator')->get('Status'); ?></label>
                                <select class="form-control select2" data-minimum-results-for-search="-1" name="status">
                                    <option value=""><?php echo app('translator')->get('All'); ?></option>
                                    <option value="<?php echo e(Status::ORDER_INITIATED); ?>" <?php if(request()->status == Status::ORDER_INITIATED): echo 'selected'; endif; ?>>
                                        <?php echo app('translator')->get('Initiated'); ?>
                                    </option>
                                    <option value="<?php echo e(Status::ORDER_PROCESSING); ?>" <?php if(request()->status == Status::ORDER_PROCESSING): echo 'selected'; endif; ?>>
                                        <?php echo app('translator')->get('Processing'); ?>
                                    </option>
                                    <option value="<?php echo e(Status::ORDER_ON_DELIVERY); ?>" <?php if(request()->status == Status::ORDER_ON_DELIVERY): echo 'selected'; endif; ?>>
                                        <?php echo app('translator')->get('On Delivery'); ?>
                                    </option>
                                    <option value="<?php echo e(Status::ORDER_DELIVERED); ?>" <?php if(request()->status == Status::ORDER_DELIVERED): echo 'selected'; endif; ?>>
                                        <?php echo app('translator')->get('Delivered'); ?>
                                    </option>
                                    <option value="<?php echo e(Status::ORDER_CANCELLED); ?>" <?php if(request()->status == Status::ORDER_CANCELLED): echo 'selected'; endif; ?>>
                                        <?php echo app('translator')->get('Cancelled'); ?>
                                    </option>
                                    <option value="<?php echo e(Status::ORDER_COMPLETED); ?>" <?php if(request()->status == Status::ORDER_COMPLETED): echo 'selected'; endif; ?>>
                                        <?php echo app('translator')->get('Completed'); ?>
                                    </option>
                                </select>
                            </div>
                            <!-- Date Range Filter -->
                            <div class="flex-grow-1">
                                <label><?php echo app('translator')->get('Date'); ?></label>
                                <input name="date" type="search"
                                    class="datepicker-here form-control bg--white pe-2 date-range"
                                    placeholder="<?php echo app('translator')->get('Start Date - End Date'); ?>" autocomplete="off" value="<?php echo e(request()->date); ?>">
                            </div>
                            <!-- Filter Button -->
                            <div class="flex-grow-1 align-self-end">
                                <button class="btn btn--primary w-100 h-45"><i class="fas fa-filter"></i>
                                    <?php echo app('translator')->get('Filter'); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('User'); ?></th>
                                    <th><?php echo app('translator')->get('Restaurant'); ?></th>
                                    <th><?php echo app('translator')->get('Address'); ?></th>
                                    <th><?php echo app('translator')->get('Total Price'); ?></th>
                                    <th><?php echo app('translator')->get('Payment Type'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <!-- User -->
                                        <td><?php echo e(@$order->user->username ?? __('N/A')); ?></td>

                                        <!-- Restaurant -->
                                        <td><?php echo e(@$order->restaurant->restaurant_name ?? __('N/A')); ?></td>

                                        <!-- Address -->
                                        <td><?php echo e($order->address ?? __('N/A')); ?></td>

                                        <!-- Total Price -->
                                        <td><?php echo e(showAmount($order->total_price)); ?></td>

                                        <!-- Payment Type -->
                                        <td>
                                            <?php echo $order->typeBadge ?>
                                        </td>

                                        <!-- Status -->
                                        <td>
                                            <?php
                                                echo $order->statusBadge;
                                            ?>
                                        </td>

                                        <!-- Action -->
                                        <td>
                                            <a href="<?php echo e(route('admin.orders.details', $order->id)); ?>"
                                                class="btn btn-sm btn-outline--primary">
                                                <i class="las la-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <?php if($orders->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($orders)); ?>

                    </div>
                <?php endif; ?>
            </div><!-- card end -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/daterangepicker.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/admin/css/daterangepicker.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict"

            const datePicker = $('.date-range').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    cancelLabel: 'Clear'
                },
                showDropdowns: true,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 15 Days': [moment().subtract(14, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(30, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                        .endOf('month')
                    ],
                    'Last 6 Months': [moment().subtract(6, 'months').startOf('month'), moment().endOf('month')],
                    'This Year': [moment().startOf('year'), moment().endOf('year')],
                },
                maxDate: moment()
            });

            const changeDatePickerText = (event, startDate, endDate) => {
                $(event.target).val(startDate.format('MMMM DD, YYYY') + ' - ' + endDate.format('MMMM DD, YYYY'));
            }

            $('.date-range').on('apply.daterangepicker', (event, picker) => changeDatePickerText(event, picker
                .startDate, picker.endDate));

            if ($('.date-range').val()) {
                let dateRange = $('.date-range').val().split(' - ');
                $('.date-range').data('daterangepicker').setStartDate(new Date(dateRange[0]));
                $('.date-range').data('daterangepicker').setEndDate(new Date(dateRange[1]));
            }

        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/admin/reports/orders.blade.php ENDPATH**/ ?>