<?php $__env->startSection('content'); ?>
    <?php
        $advertisement_banner = showAd('1296x190');
        $advertisement_category_nav = showAd('305x380');
        $request = request();
    ?>

    <section class="common-body section-bg-two pt-80 pb-80">
        <div class="container">

            <?php if($advertisement_banner): ?>
                <a class="ad-thumb"
                    <?php if($advertisement_banner['route']): ?> href="<?php echo e($advertisement_banner['route']); ?>"  target="_blank" <?php endif; ?>>
                    <img src="<?php echo e($advertisement_banner['image']); ?>" alt="ad-thumb">
                </a>
            <?php endif; ?>

            <form action="<?php echo e(route('search')); ?>" method="get" id="sortForm">
                <input type="hidden" name="type" value="<?php echo e($request->type); ?>">
                <input type="hidden" name="category" value="<?php echo e(request()->category); ?>">
                <input type="hidden" name="location" value="<?php echo e($request->location); ?>">
                <input type="hidden" name="sort" value="<?php echo e($request->sort); ?>">
                <input type="hidden" name="search" value="<?php echo e($request->search); ?>">
                <input type="hidden" name="page" value="<?php echo e($request->page); ?>">
            </form>
            <div class="row gy-4">
                <div class="col-xl-3">
                    <div class="grid-sidebar">
                        <div class="filter-sidebar__header d-flex align-items-center justify-content-between gap-2">
                            <h6 class="title">
                                <?php echo app('translator')->get('Filter'); ?> </h6>
                            <div class="right">
                                <button class="side-sidebar-close-btn d-block d-xl-none" type="button"><i
                                        class="las la-times"></i></button>
                            </div>
                        </div>
                        <form action="<?php echo e(route('search')); ?>" class="search-form search-box-wrapper mb-4">
                            <div class="search-box">
                                <input type="text" class="form--control" name="search"
                                    placeholder="<?php echo app('translator')->get('Search any keyword'); ?>..." value="<?php echo e($request->search); ?>" id="search">
                                <button type="submit" class="search-box__button"><i class="las la-search"></i></button>
                            </div>
                        </form>

                        <h6 class="grid-sidebar__title"><?php echo app('translator')->get('Type'); ?></h6>
                        <div class="category">
                            <div class="form-group">
                                <div class="form-check form--radio">
                                    <input class="form-check-input type-radio" type="radio" name="type" id="restaurant"
                                        value="restaurant" <?php if($type == 'restaurant'): echo 'checked'; endif; ?>>
                                    <label class="form-check-label" for="restaurant">
                                        <?php echo app('translator')->get('Restaurants'); ?>
                                    </label>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="form-check form--radio">
                                    <input class="form-check-input type-radio" type="radio" name="type" id="food"
                                        value="food" <?php if($type == 'food'): echo 'checked'; endif; ?>>
                                    <label class="form-check-label" for="food">
                                        <?php echo app('translator')->get('Foods'); ?>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <h6 class="grid-sidebar__title"><?php echo app('translator')->get('Category'); ?></h6>
                        <div class="category">
                            <div class="form-group">
                                <div class="form-check form--radio">
                                    <input class="form-check-input category-radio" type="radio" name="category"
                                        id="all-category" value="" checked="">
                                    <label class="form-check-label" for="all-category">
                                        <?php echo app('translator')->get('All'); ?> </label>
                                </div>
                            </div>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-group">
                                    <div class="form-check form--radio">
                                        <input class="form-check-input category-radio" type="radio" name="category"
                                            id="<?php echo e($category->slug); ?>" value="<?php echo e($category->slug); ?>"
                                            <?php if($category->slug == $request->category): echo 'checked'; endif; ?>>
                                        <label class="form-check-label" for="<?php echo e($category->slug); ?>">
                                            <?php echo e(__($category->name)); ?>

                                        </label>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php if($advertisement_category_nav): ?>
                            <a class="sidebar-thumb"
                                <?php if($advertisement_category_nav['route']): ?> href="<?php echo e($advertisement_category_nav['route']); ?>" target="_blank" <?php endif; ?>>
                                <img src="<?php echo e($advertisement_category_nav['image']); ?>" alt="ad-thumb">
                            </a>
                        <?php endif; ?>
                    </div>


                </div>
                <div class="col-xl-9">
                    <span class="event-filter d-xl-none d-block">
                        <button class="event-filter__button">
                            <i class="las la-filter"></i>
                            <span class="text"> <?php echo app('translator')->get('Filter'); ?> </span>
                        </button>
                    </span>
                    <div class="grid-event-header">
                        <span class="grid-event-header__title">
                            <?php echo app('translator')->get('Result'); ?>: <?php echo e($resultCount); ?> <?php echo app('translator')->get('items Found'); ?> </span>
                        <div class="flex-between grid-event-header-content ms-auto gap-2">
                            <div class="grid-event-form-inner">
                                <form action="#">
                                    <select class="select2-basic location-select">
                                        <option value=""><?php echo app('translator')->get('All Locations'); ?></option>
                                        <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($location->slug); ?>" <?php if($location->slug == $request->location): echo 'selected'; endif; ?>>
                                                <?php echo e(__($location->name)); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </form>
                            </div>
                            <div class="grid-event-form-inner">
                                <form action="#">
                                    <select class="select2-basic sort-select" aria-label="sort select">
                                        <option value=""><?php echo app('translator')->get('Sort By'); ?>
                                        <option value="newestToOldest" <?php if($request->sort == 'newestToOldest'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Newest to oldest'); ?>
                                        </option>
                                        <option value="oldestToNewest" <?php if($request->sort == 'oldestToNewest'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Oldest to newest'); ?>
                                        </option>
                                        <?php if($type == 'food'): ?>
                                            <option value="priceLowToHigh" <?php if($request->sort == 'priceLowToHigh'): echo 'selected'; endif; ?>>
                                                <?php echo app('translator')->get('Price'); ?>(<?php echo app('translator')->get('Low'); ?> -
                                                <?php echo app('translator')->get('High'); ?>)
                                            </option>
                                            <option value="priceHighToLow" <?php if($request->sort == 'priceHighToLow'): echo 'selected'; endif; ?>>
                                                <?php echo app('translator')->get('Price'); ?>(<?php echo app('translator')->get('High'); ?> -
                                                <?php echo app('translator')->get('Low'); ?>)</option>
                                        <?php endif; ?>
                                        <?php if($type == 'restaurant'): ?>
                                            <option value="ratingLowToHigh" <?php if($request->sort == 'ratingLowToHigh'): echo 'selected'; endif; ?>>
                                                <?php echo app('translator')->get('Rating'); ?>(<?php echo app('translator')->get('Low'); ?> -
                                                <?php echo app('translator')->get('High'); ?>)
                                            </option>
                                            <option value="ratingHighToLow" <?php if($request->sort == 'ratingHighToLow'): echo 'selected'; endif; ?>>
                                                <?php echo app('translator')->get('Rating'); ?>(<?php echo app('translator')->get('High'); ?> -
                                                <?php echo app('translator')->get('Low'); ?>)</option>
                                        <?php endif; ?>
                                        <option value="location" <?php if($request->sort == 'location'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Location'); ?></option>
                                        <option value="restaurant" <?php if($request->sort == 'restaurant'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Restaurants'); ?>
                                        </option>
                                    </select>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="row gy-4">
                        <?php $__empty_1 = true; $__currentLoopData = $data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php if($type == 'restaurant'): ?>
                                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col--xm-6">
                                    <?php if (isset($component)) { $__componentOriginalfd767bbaafc668b79b7c0622527faddd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfd767bbaafc668b79b7c0622527faddd = $attributes; } ?>
<?php $component = App\View\Components\Restaurant::resolve(['restaurant' => $item] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('restaurant'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Restaurant::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfd767bbaafc668b79b7c0622527faddd)): ?>
<?php $attributes = $__attributesOriginalfd767bbaafc668b79b7c0622527faddd; ?>
<?php unset($__attributesOriginalfd767bbaafc668b79b7c0622527faddd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfd767bbaafc668b79b7c0622527faddd)): ?>
<?php $component = $__componentOriginalfd767bbaafc668b79b7c0622527faddd; ?>
<?php unset($__componentOriginalfd767bbaafc668b79b7c0622527faddd); ?>
<?php endif; ?>
                                </div>
                            <?php elseif($type == 'food'): ?>
                                <div class="col-md-6 col-sm-6 col--xm-6">
                                    <?php if (isset($component)) { $__componentOriginal22c73ba8f85811a30cbeee26dcdccf02 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal22c73ba8f85811a30cbeee26dcdccf02 = $attributes; } ?>
<?php $component = App\View\Components\Food::resolve(['food' => $item] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('food'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Food::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['isSection' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal22c73ba8f85811a30cbeee26dcdccf02)): ?>
<?php $attributes = $__attributesOriginal22c73ba8f85811a30cbeee26dcdccf02; ?>
<?php unset($__attributesOriginal22c73ba8f85811a30cbeee26dcdccf02); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal22c73ba8f85811a30cbeee26dcdccf02)): ?>
<?php $component = $__componentOriginal22c73ba8f85811a30cbeee26dcdccf02; ?>
<?php unset($__componentOriginal22c73ba8f85811a30cbeee26dcdccf02); ?>
<?php endif; ?>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="text-center"><?php echo e(__($emptyMessage)); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mt-3">
                        <?php echo e(paginateLinks($data)); ?>

                    </div>

                </div>
            </div>

        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $(document).ready(function() {
                $('.type-radio').on('change', function() {
                    $('#sortForm').find('input[name="type"]').val(this.value);
                    $('#sortForm').find('input[name="page"]').val(null)
                    $('#sortForm').submit();
                });


                $('.category-radio').on('change', function() {
                    $('#sortForm').find('input[name="category"]').val(this.value);
                    $('#sortForm').find('input[name="page"]').val(null)
                    $('#sortForm').submit();
                });

                $('.location-select').on('change', function() {
                    $('#sortForm').find('input[name="location"]').val(this.value);
                    $('#sortForm').find('input[name="page"]').val(null)
                    $('#sortForm').submit();
                });

                $('.sort-select').on('change', function() {
                    $('#sortForm').find('input[name="sort"]').val(this.value);
                    $('#sortForm').find('input[name="page"]').val(null)
                    $('#sortForm').submit();
                });

                $('.search-form').on('submit', function(e) {
                    e.preventDefault();
                    var value = $(this).find('input[name="search"]').val();
                    $('#sortForm').find('input[name="search"]').val(value);
                    $('#sortForm').find('input[name="page"]').val(null)
                    $('#sortForm').submit();
                });

                $('.pagination a').each(function() {
                    $(this).removeAttr('href').attr('href', 'javascript:void(0)');
                });

                $('.pagination a').on('click', function() {
                    var page = this.innerText;
                    var currentActivePage = parseInt($('.page-item.active .page-link').text());
                    if (page == '‹') {
                        page = parseInt(currentActivePage - 1);
                    }
                    if (page == '›') {
                        page = parseInt(currentActivePage + 1);
                    }
                    $('#sortForm').find('input[name="page"]').val(page);
                    $('#sortForm').submit();
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/search.blade.php ENDPATH**/ ?>