<?php $__env->startSection('content'); ?>
    <?php if(gs('restaurant_registration')): ?>
        <?php
            $policyPages = getContent('policy_pages.element', false, null, true);
            $loginRegistration = getContent('login_registration.content', true);
        ?>
        <div class="inner-banner-breadcrumbs">
            <div class="container">
                <div class="row justify-content-center">
                    <ul class="breadcrumbs d-flex flex-wrap align-items-center justify-content-center">
                        <li><a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                        <li><?php echo e($pageTitle); ?></li>
                    </ul>
                </div>
            </div>
        </div>
        <section class="account section-bg-two pt-80 pb-80">
            <img class="account-shape-three"
                src="<?php echo e(frontendImage('login_registration', @$loginRegistration->data_values->image_one, '515x380')); ?>"
                alt="img not found" />
            <img class="account-shape-four"
                src="<?php echo e(frontendImage('login_registration', @$loginRegistration->data_values->image_two, '630x405')); ?>"
                alt="img not found" />
            <img class="account-shape-four-dark"
                src="<?php echo e(frontendImage('login_registration', @$loginRegistration->data_values->image_two_dark, '630x405')); ?>"
                alt="img not found" />
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-6 col-md-10">
                        <div class="change-password">
                            <form action="<?php echo e(route('restaurant.register')); ?>" method="POST"
                                class="signup-form verify-gcaptcha disableSubmission">
                                <?php echo csrf_field(); ?>
                                <div class="signup-form-top text-center pb-30">
                                    <div class="signup-page__content text-center">
                                        <h2><?php echo app('translator')->get('Register'); ?></h2>
                                    </div>
                                </div>
                                <?php echo $__env->make($activeTemplate . 'partials.social_login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <div class="row">

                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" id="email" placeholder="none"
                                                    class="form-control form--control checkUser" name="email"
                                                    value="<?php echo e(old('email')); ?>" required>
                                                <label for="email"><?php echo app('translator')->get('E-Mail Address'); ?></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <select id="location" name="location" placeholder="none"
                                                    class="form-select form-control form--control select2-basic" required>
                                                    <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($location->id); ?>" name="location">
                                                            <?php echo e(__($location->name)); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <label for="location"><?php echo app('translator')->get('Location'); ?></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="number" id="mobile" placeholder="none"
                                                    class="form-control form--control checkUser" name="mobile"
                                                    value="<?php echo e(old('mobile')); ?>" required>
                                                <label for="mobile"><?php echo app('translator')->get('Mobile'); ?></label>
                                            </div>
                                            <small class="text--danger mobileExist"></small>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="password" id="password" placeholder="none"
                                                    class="form-control form--control <?php if(gs('secure_password')): ?> secure-password <?php endif; ?>"
                                                    name="password" required>
                                                <label for="password"><?php echo app('translator')->get('Password'); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input name="password_confirmation" type="password" id="c-password"
                                                    placeholder="none" class="form-control form--control" required>
                                                <label for="c-password"><?php echo app('translator')->get('Confirm Password'); ?></label>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>

                                    <?php if(gs('agree')): ?>
                                        <div class="col-12">
                                            <div class="form-group">
                                                <div class="form-check custom--checkbox">
                                                    <input class="form-check-input" type="checkbox" id="agree"
                                                        name="agree">
                                                    <label class="form-check-label" for="agree">
                                                        <?php echo app('translator')->get('I agree with'); ?>
                                                    </label>
                                                    <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <a class="text--base"
                                                            href="<?php echo e(route('policy.pages', [slug(@$policy->data_values->title), $policy->id])); ?>"
                                                            target="_blank"><?php echo e(__(@$policy->data_values->title)); ?></a>
                                                        <?php if(!$loop->last): ?>
                                                            ,
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <div class="col-12 mb-20 mt-3">
                                        <button type="submit" id="recaptcha" class="btn btn--base w-100 btn--md">
                                            <?php echo app('translator')->get('Register'); ?>
                                        </button>
                                    </div>

                                    <div class="col-12">
                                        <p class="text-center heading-color mb-0">
                                            <?php echo app('translator')->get('Already have an account?'); ?>
                                            <a href="<?php echo e(route('restaurant.login')); ?>"
                                                class="text--base"><?php echo app('translator')->get('Login'); ?></a>
                                        </p>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <div class="modal fade" id="existModalCenter" tabindex="-1" role="dialog" aria-labelledby="existModalCenterTitle"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="existModalLongTitle"><?php echo app('translator')->get('You are with us'); ?></h5>
                        <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </span>
                    </div>
                    <div class="modal-body">
                        <p class="text-center"><?php echo app('translator')->get('You already have an account please Login '); ?></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-dark btn--sm"
                            data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <a href="<?php echo e(route('restaurant.login')); ?>" class="btn btn--base btn--sm"><?php echo app('translator')->get('Login'); ?></a>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <?php echo $__env->make($activeTemplate . 'partials.registration_disabled', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .country-code .input-group-text {
            background: #fff !important;
        }

        .country-code select {
            border: none;
        }

        .country-code select:focus {
            border: none;
            outline: none;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php if(gs('secure_password')): ?>
    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/auth/register.blade.php ENDPATH**/ ?>