
<?php $__env->startSection('content'); ?>
    <div class="py-70">
        <div class="container">
            <div class="row justify-content-center mt-2">
                <div class="col-lg-12 ">
                    <div class="card custom--card">
                        <div class="card-body">
                            <form class="register" action="<?php echo e(route('restaurant.delivery.setting.store')); ?>" method="post"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="form-group col-sm-12">
                                        <label class="form-label"><?php echo app('translator')->get('Delivery Time'); ?></label>
                                        <div class="input-group">
                                            <input type="number" class="form-control form--control" name="delivery_time"
                                                value="<?php echo e($restaurant->delivery_time ? $restaurant->delivery_time : old('delivery_time')); ?>"
                                                required>
                                            <div class="input-group-text"><?php echo app('translator')->get('Minutes'); ?></div>
                                        </div>
                                    </div>

                                    <div class="form-group col-sm-12">
                                        <label class="form-label"><?php echo app('translator')->get('Delivery Charge'); ?></label>
                                        <div class="input-group">
                                            <input type="number" class="form-control form--control" name="delivery_charge"
                                                value="<?php echo e($restaurant->delivery_charge ? showAmount($restaurant->delivery_charge, currencyFormat: false) : old('delivery_charge')); ?>"
                                                required>
                                            <div class="input-group-text"><?php echo e(gs('cur_sym')); ?></div>
                                        </div>
                                    </div>

                                    <div class="form-group col-sm-12">
                                        <label class="form-label"><?php echo app('translator')->get('Vat'); ?></label>
                                        <div class="input-group">
                                            <input type="number" class="form-control form--control" name="vat"
                                                value="<?php echo e($restaurant->vat ? showAmount($restaurant->vat, currencyFormat: false) : old('vat')); ?>"
                                                required>
                                            <div class="input-group-text">%</div>
                                        </div>
                                    </div>
                                    <div class="form-group col-sm-12">
                                        <label class="form-label"><?php echo app('translator')->get('حالة المطعم'); ?></label>
                                        <select name="provider" class="form-control form--control" required>
                                            <option value="مفتوح" <?php echo e($restaurant->provider == 'مفتوح' ? 'selected' : ''); ?>>مفتوح</option>
                                            <option value="مشغول" <?php echo e($restaurant->provider == 'مشغول' ? 'selected' : ''); ?>>مشغول</option>
                                            <option value="مغلق" <?php echo e($restaurant->provider == 'مغلق' ? 'selected' : ''); ?>>مغلق</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Submit'); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'restaurant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/delivery_setting.blade.php ENDPATH**/ ?>