<?php $__env->startSection('content'); ?>
    <div class="py-70">
        <div class="container">
            <div class="row justify-content-center mt-2">
                <div class="col-lg-12 ">
                    <div class="dashboard-table">
                        <div class="dashbaord-table-header">
                            <h6 class="card-header__title mb-0"><?php echo e($pageTitle); ?> <i
                                    class="las la-hamburger text--base"></i></h6>
                            <form class="search-form active">
                                <input type="text" name="search" class="form--control" value="<?php echo e(request()->search); ?>"
                                    placeholder="<?php echo app('translator')->get('Search here'); ?>...">
                                <button type="submit" class="search-form__btn"><i class="las la-search"></i></button>
                            </form>
                        </div>


                        <table class="table table--responsive--lg">
                            <thead>
                                <tr>
                                    
                                    <th>رقم الطلب</th>
                                    <th> رقم الموبايل للعميل</th>
                                    <th><?php echo app('translator')->get('User'); ?></th>
                                    <th><?php echo app('translator')->get('Address'); ?></th>
                                    <th><?php echo app('translator')->get('Total Price'); ?></th>
                                    <th><?php echo app('translator')->get('Payment Type'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                          <?php echo e($order->id); ?>

                                        </td>
                                        <td>
                                         <?php echo e($order->user->mobile); ?>

                                        </td>
                                        <td>    
                                            <div>
                                                <?php echo e(__($order->user->fullname)); ?> <br />
                                                <small><a
                                                        href="<?php echo e(route('restaurant.order.index', ['search' => $order->user->username])); ?>"><?php echo e(__($order->user->username)); ?></a></small>
                                            </div>
                                        </td>
                                        <td>
                                            <?php echo e(__(strLimit($order->address, 40))); ?>

                                        </td>

                                        <td>
                                            <div>
                                                <?php echo e(showAmount($order->total_price)); ?> <br>
                                                <small
                                                    class="text--base"><?php echo e(showDateTime($order->created_at, 'd/m/y @ h A')); ?></small>
                                            </div>
                                        </td>

                                        <td>
                                            <?php echo $order->typeBadge ?>
                                        </td>

                                        <td>
                                            <?php echo $order->statusBadge ?>
                                            <?php if($order->status == Status::ORDER_DELIVERED): ?>
                                                <span class="infoIcon" data-toggle="tooltip" data-placement="top"
                                                    title="<?php echo app('translator')->get('Payment will get dispersed once user confirms the order'); ?>">
                                                    <i class="fas fa-info-circle"></i>
                                                </span>
                                            <?php endif; ?>
                                        </td>

                                        <td>
                                            <a href="<?php echo e(route('restaurant.order.details', $order->id)); ?>"
                                                class="btn btn--sm btn--base btn-outline--base btn--sm">
                                                <i class="la la-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted empty-message" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        <?php if($orders->hasPages()): ?>
                            <?php echo e(paginateLinks($orders)); ?>

                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<script>
    const currentRoute = "<?php echo e(\Illuminate\Support\Facades\Route::currentRouteName()); ?>";

    if(currentRoute === 'restaurant.order.processing' || currentRoute === 'restaurant.order.active'){
        setInterval(function() {
            window.location.reload();
        }, 20000); // كل 20 ثواني
    }
</script>

<?php echo $__env->make($activeTemplate . 'restaurant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/order/index.blade.php ENDPATH**/ ?>