<?php $__env->startSection('content'); ?>
    <?php
        $kycInstruction = getContent('kyc_instruction.content', true);
    ?>

    <div class="notice"></div>

    <?php
        $kyc = getContent('kyc.content', true);
    ?>
    <?php if(auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason): ?>
        <div class="dashboard-widget flex-align alert-danger mb-3">
            <span class="dashboard-widget__icon flex-center"><i class="las la-user-times"></i></span>
            <div class="dashboard-widget__content">
                <h6 class="dashboard-widget__text"><?php echo app('translator')->get('KYC Documents Rejected'); ?></h6>
                <p class="dashboard-widget__number">
                    <?php echo e(__(@$kyc->data_values->reject)); ?>

                    <a href="<?php echo e(route('user.kyc.form')); ?>" class="text--base"><?php echo app('translator')->get('Click Here to Re-submit Documents'); ?></a>.
                    <br>

                    <a href="<?php echo e(route('user.kyc.data')); ?>" class="text--base"><?php echo app('translator')->get('View KYC Data'); ?></a> /
                    <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#kycRejectionReason"
                        class="text--base">
                        <?php echo app('translator')->get('Show Rejection Reason'); ?>
                    </a>
                </p>
            </div>
        </div>
    <?php elseif(auth()->user()->kv == Status::KYC_UNVERIFIED): ?>
        <div class="dashboard-widget flex-align alert-info mb-3">
            <span class="dashboard-widget__icon flex-center"><i class="las la-user-check"></i></span>
            <div class="dashboard-widget__content">
                <h6 class="dashboard-widget__text"><?php echo app('translator')->get('KYC Verification Required'); ?></h6>
                <p class="dashboard-widget__number">
                    <?php echo e(__(@$kyc->data_values->required)); ?>

                    <a href="<?php echo e(route('user.kyc.form')); ?>" class="text--base"><?php echo app('translator')->get('Click Here to Submit Documents'); ?></a>
                </p>
            </div>
        </div>
    <?php elseif(auth()->user()->kv == Status::KYC_PENDING): ?>
        <div class="dashboard-widget flex-align alert-warning mb-3">
            <span class="dashboard-widget__icon flex-center"><i class="las la-user-clock"></i></span>
            <div class="dashboard-widget__content">
                <h6 class="dashboard-widget__text"><?php echo app('translator')->get('KYC Verification Pending'); ?></h6>
                <p class="dashboard-widget__number">
                    <?php echo e(__(@$kyc->data_values->pending)); ?>

                    <a href="<?php echo e(route('user.kyc.data')); ?>" class="text--base"><?php echo app('translator')->get('See KYC Data'); ?></a>
                </p>
            </div>
        </div>
    <?php endif; ?>


    <div class="row gy-3 justify-content-center dashboard-widget-wrapper">

        <div class="col-xl-4 col-md-4 col-sm-6 col-xsm-6">
            <a href="<?php echo e(route('user.order.index')); ?>" class="dashboard-widget flex-align">
                <span class="dashboard-widget__icon flex-center"><i class="las la-file-alt"></i></span>
                <div class="dashboard-widget__content">
                    <span class="dashboard-widget__text"><?php echo app('translator')->get('Orders'); ?></span>
                    <h4 class="dashboard-widget__number"><?php echo e($widget['total_orders']); ?></h4>
                </div>
            </a>
        </div>
        <div class="col-xl-4 col-md-4 col-sm-6 col-xsm-6">
            <a href="<?php echo e(route('user.order.active')); ?>" class="dashboard-widget flex-align">
                <span class="dashboard-widget__icon flex-center"><i class="las la-calendar-check"></i></span>
                <div class="dashboard-widget__content">
                    <span class="dashboard-widget__text"><?php echo app('translator')->get('Active Orders'); ?></span>
                    <h4 class="dashboard-widget__number"><?php echo e($widget['active_orders']); ?></h4>
                </div>
            </a>
        </div>


        <div class="col-xl-4 col-md-4 col-sm-6 col-xsm-6">
            <a href="<?php echo e(route('user.favorite.foods')); ?>" class="dashboard-widget flex-align">
                <span class="dashboard-widget__icon flex-center"><i class="las la-hamburger"></i></span>
                <div class="dashboard-widget__content">
                    <span class="dashboard-widget__text"><?php echo app('translator')->get('Favorite Foods'); ?></span>
                    <h4 class="dashboard-widget__number"><?php echo e($widget['favorite_foods']); ?></h4>
                </div>
            </a>
        </div>
        <div class="col-xl-4 col-md-4 col-sm-6 col-xsm-6">
            <a href="<?php echo e(route('favorite.restaurants')); ?>" class="dashboard-widget flex-align">
                <span class="dashboard-widget__icon flex-center"><i class="las la-heartbeat"></i></span>
                <div class="dashboard-widget__content">
                    <span class="dashboard-widget__text"><?php echo app('translator')->get('Favorite Restaurants'); ?></span>
                    <h4 class="dashboard-widget__number"><?php echo e($widget['favorite_restaurants']); ?></h4>
                </div>
            </a>
        </div>
    </div>

    <div class="row g-3 justify-content-center mt-4">
        <div class="col-12">
            <div class="dashboard-table">
                <div class="dashbaord-table-header">
                    <h6 class="card-header__title mb-0"><?php echo app('translator')->get('Orders'); ?></h6>
                </div>
                <table class="table table--responsive--xl">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Restaurant name'); ?></th>
                            <th class="text-center"><?php echo app('translator')->get('Price'); ?></th>
                            <th class="text-center"><?php echo app('translator')->get('Payment'); ?></th>
                            <th class="text-center"><?php echo app('translator')->get('Payment Type'); ?></th>
                            <th class="text-center"><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $latestOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td lass="text-left">
                                    <span class="fw-bold">
                                        <a href="<?php echo e(route('restaurant.details', @$order->restaurant->slug)); ?>"
                                            class="text--base">
                                            <?php echo e(__(@$order->restaurant->restaurant_name)); ?>

                                        </a>
                                    </span>
                                </td>
                                <td class="text-center">
                                    <?php echo e(showAmount($order->total_price)); ?>

                                </td>
                                <td class="text-center">
                                    <?php echo $order->paymentData ?>
                                </td>

                                <td>
                                    <?php echo $order->typeBadge ?>
                                </td>
    
                                <td class="text-center">
                                    <?php echo $order->statusBadge ?>
                                </td>
                                <td>
                                    <a class="btn btn--sm btn--base detailBtn"
                                        href="<?php echo e(route('user.order.details', $order->id)); ?>">
                                        <i class="la la-desktop"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php if(auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason): ?>
    <div class="modal fade" id="kycRejectionReason">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('KYC Document Rejection Reason'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo e(auth()->user()->kyc_rejection_reason); ?></p>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/user/dashboard.blade.php ENDPATH**/ ?>