<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9">
                <?php echo $__env->make($activeTemplate . 'restaurant.partials.food_progress_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
        <div class="card custom--card mt-5 mb-3">
            <div class="card-body">
                <form id="foodForm">
                    <div class="form-group">
                        <label class="form-label required"><?php echo app('translator')->get('Name'); ?></label>
                        <input type="text" class="form-control form--control" name="name"
                            value="<?php echo e(old('name', @$food->name)); ?>" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label required"><?php echo app('translator')->get('Short Description'); ?></label>
                        <input type="text" class="form-control form--control" name="short_description"
                            value="<?php echo e(old('short_description', @$food->short_description)); ?>" required>
                    </div>

                    <div class="form-group select2-parent position-relative">
                        <label><?php echo app('translator')->get('Categories'); ?></label>
                        <small class="ms-2 mt-2  "><?php echo app('translator')->get('Separate multiple keywords by'); ?> <code>,</code>(<?php echo app('translator')->get('comma'); ?>) <?php echo app('translator')->get('or'); ?>
                            <code><?php echo app('translator')->get('enter'); ?></code> <?php echo app('translator')->get('key'); ?></small>
                        <select name="categories[]" class="form-control select2-auto-tokenize" multiple="multiple" required>
                            <?php if(@$categories): ?>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>"
                                        <?php if($food): ?> <?php echo e($food->categories->contains('id', $category->id) ? 'selected' : ''); ?> <?php endif; ?>>
                                        <?php echo e(__($category->name)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                    </div>


                    <div class="form-group">
                        <label class="form-label required"><?php echo app('translator')->get('Price'); ?></label>
                        <div class="input-group">
                            <input type="number" class="form-control form--control" name="price"
                                value="<?php echo e(old('price', showAmount(@$food->price, currencyFormat: false))); ?>" required>
                            <div class="input-group-text"><?php echo e(gs('cur_sym')); ?></div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="d-flex justify-content-end">
            <?php if(!request()->routeIs('restaurant.food.publish')): ?>
                <button class="btn btn--base" id="saveAndContinue" type="button">
                    <?php echo app('translator')->get('Save & Continue'); ?> <i class="las la-angle-right"></i>
                </button>
            <?php endif; ?>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/restaurant/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/restaurant/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>



<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('.select2-auto-tokenize').select2({
                dropdownParent: $('.select2-parent'),
                tags: false,
                tokenSeparators: [',']
            });

            //Ajax
            $('#saveAndContinue').on('click', function() {
                var btn = $(this);
                var btnName = `<?php echo app('translator')->get('Save & Continue'); ?> <i class="las la-angle-right"></i>`;

                //store
                var formData = new FormData($('#foodForm')[0]);
                var url = '<?php echo e(route('restaurant.food.store.overview', @$food->id ?? '')); ?>';
                var token = '<?php echo e(csrf_token()); ?>';
                formData.append('_token', token);


                $.ajax({
                    url: url,
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        var btnAfterSubmit =
                            `<div class="spinner-border"></div> <?php echo app('translator')->get('Saving'); ?>...`;
                        btn.html(btnAfterSubmit);
                        btn.attr('disabled', true);
                    },
                    complete: function(e) {
                        btn.html(btnName);
                        btn.removeAttr('disabled');
                    },
                    success: function(response) {
                        if (response.success) {
                            <?php if(!$food): ?>
                                window.location.href = response.redirect_url
                            <?php else: ?>
                                notify('success', `<?php echo app('translator')->get('Food overview updated successfully'); ?>`);
                                btn.html(btnName);
                                btn.removeAttr('disabled');
                            <?php endif; ?>
                        } else {
                            notify('error', response.message);
                            btn.html(btnName);
                            btn.removeAttr('disabled');
                        }
                    },
                    error: function(xhr, status, error) {
                        notify('error', error);
                        btn.html(btnName);
                        btn.removeAttr('disabled');
                    }
                });

            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'restaurant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/food/overview.blade.php ENDPATH**/ ?>