<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9"> <?php echo $__env->make($activeTemplate . 'restaurant.partials.food_progress_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> </div>
        </div>
        <form id="foodForm">
            <?php $__empty_1 = true; $__currentLoopData = $food->variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="card custom--card mt-5 mb-3 variant" data-id="<?php echo e($variant->id); ?>">
                    <div class="card-body">
                        <div class="form-group mb-4">
                            <label class="form-label required"><?php echo app('translator')->get('Variant Title'); ?></label>
                            <input type="text" class="form-control form--control"
                                name="variations[<?php echo e($variant->id); ?>][title]" value="<?php echo e(__($variant->title)); ?>" required>
                            <button class="btn btn--danger deleteVariant"><i class="las la-times"
                                    aria-hidden="true"></i></button>
                        </div>

                        <?php $__currentLoopData = $variant->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="row variant-item">
                                <div class="col flex-input">
                                    <div class="form-group">
                                        <label class="form-label required"><?php echo app('translator')->get('Name'); ?></label>
                                        <input type="text"
                                            name="variations[<?php echo e($variant->id); ?>][items][<?php echo e($item->id); ?>][name]"
                                            class="form-control form--control" value="<?php echo e($item->name); ?>" required>
                                    </div>
                                </div>

                                <div class="col flex-input">
                                    <div class="form-group">
                                        <label class="form-label required"><?php echo app('translator')->get('Price'); ?></label>
                                        <div class="input-group">
                                            <input type="number" class="form-control form--control"
                                                name="variations[<?php echo e($variant->id); ?>][items][<?php echo e($item->id); ?>][price]"
                                                value="<?php echo e(showAmount($item->price, currencyFormat: false)); ?>" required>
                                            <div class="input-group-text"><?php echo e(gs('cur_sym')); ?></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-auto">
                                    <button class="btn btn--danger deleteVariantItem">
                                        <i class="las la-times" aria-hidden="true"></i>
                                    </button>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <button type="button" class="btn btn--base w-100 addItemBtn">
                            <i class="las la-plus" aria-hidden="true"></i> <?php echo app('translator')->get('Add Item'); ?>
                        </button>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="card custom--card mt-5 mb-3 empty-message" data-id="220002">
                    <div class="card-body">
                        <p class="card-text text-center"><?php echo e($emptyMessage); ?></p>
                    </div>
                </div>
            <?php endif; ?>
        </form>
        <div class="d-flex justify-content-between">
            <button class="btn btn--base addVariant" type="button"> <?php echo app('translator')->get('Add Variant'); ?> <i class="las la-plus"></i>
            </button>

            <button class="btn btn--base" id="saveAndContinue" type="button"> <?php echo app('translator')->get('Save & Continue'); ?> <i
                    class="las la-angle-right"></i>
            </button>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        button.btn.btn--danger.deleteVariantItem {
            margin-top: 32px;
        }

        @media only screen and (max-width: 768px) {
            button.btn.btn--danger.deleteVariantItem {
                padding: 14px 6px;
            }
        }

        .deleteVariant {
            position: absolute;
            top: 0px;
            right: 0;
            padding: 2px;
            border-radius: 50%;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            function generateRandomNumber() {
                return Math.floor(Math.random() * (999999 - 100000 + 1)) + 100000;
            }

            function displayEmptyMessage() {
                if ($('.variant').length > 0) {
                    $('.empty-message').addClass('d-none');
                } else {
                    $('.empty-message').removeClass('d-none');
                }
            }



            $(document).ready(function() {
                $(document).on("click", '.addItemBtn', function() {
                    event.preventDefault(); // Prevent default form submission
                    var variantId = $(this).closest('.variant').data('id');
                    var itemId = generateRandomNumber();
                    var variantItemHTML = `
                        <div class="row variant-item">
                            <div class="col flex-input">
                                <div class="form-group">
                                    <label class="form-label required"><?php echo app('translator')->get('Name'); ?></label>
                                    <input type="text"
                                        name="variations[${variantId}][items][${itemId}][name]"
                                        class="form-control form--control" value="" required>
                                </div>
                            </div>

                            <div class="col flex-input">
                                <div class="form-group">
                                    <label class="form-label required"><?php echo app('translator')->get('Price'); ?></label>
                                    <div class="input-group">
                                        <input type="number" class="form-control form--control"
                                            name="variations[${variantId}][items][${itemId}][price]"
                                            value="" required>
                                        <div class="input-group-text"><?php echo e(gs('cur_sym')); ?></div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-auto">
                                <button class="btn btn--danger deleteVariantItem">
                                    <i class="las la-times" aria-hidden="true"></i>
                                </button>
                            </div>
                        </div>
                    `

                    $(this).before(variantItemHTML);
                });

                $(document).on("click", '.deleteVariant', function() {
                    event.preventDefault(); // Prevent default form submission
                    var $variant = $(this).closest('.variant');
                    $variant.remove(); // Remove the closest variant when delete button clicked
                    displayEmptyMessage();
                });


                $(document).on("click", '.deleteVariantItem', function() {
                    event.preventDefault(); // Prevent default form submission
                    var $variantItem = $(this).closest('.variant-item');
                    $variantItem
                        .remove(); // Remove the closest variant item when delete button clicked
                });



                $(document).on("click", '.addVariant', function() {
                    event.preventDefault(); // Prevent default form submission
                    var variantId = generateRandomNumber();
                    var variantHTML = `
                    <div class="card custom--card mt-5 mb-3 variant" data-id="${variantId}">
                        <div class="card-body">
                            <div class="form-group mb-4">
                                <label class="form-label required"><?php echo app('translator')->get('Variant Title'); ?></label>
                                <input type="text" class="form-control form--control" name="variations[${variantId}][title]" required>
                                <button class="btn btn--danger deleteVariant"><i class="las la-times" aria-hidden="true"></i></button>
                            </div>
                            <button type="button" class="btn btn--base w-100 addItemBtn">
                                <i class="las la-plus" aria-hidden="true"></i> <?php echo app('translator')->get('Add Item'); ?>
                            </button>
                        </div>
                    </div>
                    `
                    $('#foodForm').append(variantHTML);
                    displayEmptyMessage();
                });


            });

            //Ajax
            $('#saveAndContinue').on('click', function() {
                var btn = $(this);
                var btnName = `<?php echo app('translator')->get('Save & Continue'); ?> <i class="las la-angle-right"></i>`;

                //store
                var formData = new FormData($('#foodForm')[0]);
                var url = '<?php echo e(route('restaurant.food.store.variation', @$food->id ?? '')); ?>';
                var token = '<?php echo e(csrf_token()); ?>';
                formData.append('_token', token);

                $.ajax({
                    url: url,
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        var btnAfterSubmit =
                            `<div class="spinner-border"></div> <?php echo app('translator')->get('Saving'); ?>...`;
                        btn.html(btnAfterSubmit);
                        btn.attr('disabled', true);
                    },
                    complete: function(e) {
                        btn.html(btnName);
                        btn.removeAttr('disabled');
                    },
                    success: function(response) {
                        if (response.success) {
                            if (!response.is_update) {
                                window.location.href = response.redirect_url
                            } else {
                                notify('success', `<?php echo app('translator')->get('Variations updated successfully'); ?>`);
                                btn.html(btnName);
                                btn.removeAttr('disabled');
                            }
                        } else {
                            notify('error', response.message);
                            btn.html(btnName);
                            btn.removeAttr('disabled');
                        }
                    },
                    error: function(xhr, status, error) {
                        notify('error', error);
                        btn.html(btnName);
                        btn.removeAttr('disabled');
                    }
                });

            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'restaurant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/food/variation.blade.php ENDPATH**/ ?>