<?php $__env->startSection('content'); ?>
    <div class="py-70">
        <div class="container">
            <div class="row justify-content-center mt-2">
                <div class="col-lg-12 ">
                    <div class="dashboard-table">
                        <div class="dashbaord-table-header">
                            <h6 class="card-header__title mb-0"><?php echo app('translator')->get('Logs'); ?> <i
                                    class="las la-file-invoice-dollar text--base"></i></h6>
                            <div>
                                <div class="d-flex justify-content-end mb-1">
                                    <?php echo authRestaurant()->reviewStars ?>
                                </div>
                                <small><?php echo app('translator')->get('Average Rating'); ?></small>
                            </div>
                        </div>

                        <table class="table table--responsive--xl">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('User'); ?></th>
                                    <th class="text-center"><?php echo app('translator')->get('Stars'); ?></th>
                                    <th class="text-center"><?php echo app('translator')->get('Review'); ?></th>
                                    <th class="text-center"><?php echo app('translator')->get('Reviewed at'); ?></th>
                                    <th class="text-end"><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <?php echo e(__($review->user->fullname)); ?>

                                        </td>
                                        <td class="text-center">
                                            <div>
                                                <?php for($i = 0; $i < $review->rating; $i++): ?>
                                                    <i class="las la-star active"></i>
                                                <?php endfor; ?>
                                                <?php for($i = 0; $i < 5 - $review->rating; $i++): ?>
                                                    <i class="las la-star"></i>
                                                <?php endfor; ?>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <?php echo e(strLimit(__($review->review), 20)); ?>

                                        </td>

                                        <td>
                                            <?php echo e(diffForHumans($review->updated_at)); ?>

                                        </td>
                                        <td>
                                            <button class="btn btn--sm btn--base detailBtn"
                                                data-review="<?php echo e(__($review->review)); ?>">
                                                <i class="la la-desktop"></i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted empty-message" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        <?php if($reviews->hasPages()): ?>
                            <?php echo e(paginateLinks($reviews)); ?>

                        <?php endif; ?>
                    </div>

                </div>
            </div>
        </div>
    </div>



    <div id="detailModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Review'); ?></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="review-message"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark btn--sm" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');
                var review = $(this).data('review');
                modal.find('.review-message').text(review);
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'restaurant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/reviews.blade.php ENDPATH**/ ?>