<?php $__env->startSection('content'); ?>
    <div class="py-70">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card custom--card">
                        <div class="card-body p-0">
                            <div class="dashboard-table">
                                <div class="dashbaord-table-header">
                                    <h6 class="card-header__title mb-0">
                                        <?php echo e($pageTitle); ?> <i class="las la-file-invoice-dollar text--base"></i>
                                    </h6>
                                    <form class="search-form active">
                                        <input type="search" name="search" class="form--control"
                                            value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Search by transactions'); ?>">
                                        <button type="submit" class="search-form__btn">
                                            <i class="las la-search"></i>
                                        </button>
                                    </form>
                                </div>
                                <table class="table custom--table table--responsive--xl">
                                    <thead>
                                        <tr>
                                            <th><?php echo app('translator')->get('Gateway | Transaction'); ?></th>
                                            <th class="text-center"><?php echo app('translator')->get('Initiated'); ?></th>
                                            <th class="text-center"><?php echo app('translator')->get('Amount'); ?></th>
                                            <th class="text-center"><?php echo app('translator')->get('Conversion'); ?></th>
                                            <th class="text-center"><?php echo app('translator')->get('Status'); ?></th>
                                            <th><?php echo app('translator')->get('Details'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td>
                                                    <div>
                                                        <span class="fw-bold">
                                                            <span class="text--base">
                                                                <?php if($deposit->method_code < 5000): ?>
                                                                    <?php echo e(__(@$deposit->gateway->name)); ?>

                                                                <?php else: ?>
                                                                    <?php echo app('translator')->get('Google Pay'); ?>
                                                                <?php endif; ?>
                                                            </span>
                                                        </span>
                                                        <br>
                                                        <small><?php echo e($deposit->trx); ?></small>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <div>
                                                        <?php echo e(showDateTime($deposit->created_at)); ?><br>
                                                        <?php echo e(diffForHumans($deposit->created_at)); ?>

                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <div>
                                                        <?php echo e(showAmount($deposit->amount)); ?> +
                                                        <span class="text--danger" data-bs-toggle="tooltip"
                                                            data-bs-placement="top" data-bs-title="<?php echo app('translator')->get('Charge'); ?>">
                                                            <?php echo e(showAmount($deposit->charge)); ?>

                                                        </span>
                                                        <br>
                                                        <strong data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Amount with charge'); ?>">
                                                            <?php echo e(showAmount($deposit->amount + $deposit->charge)); ?>

                                                        </strong>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <div>
                                                        1 <?php echo e(__(gs('cur_text'))); ?> =
                                                        <?php echo e(showAmount($deposit->rate, currencyFormat: false)); ?>

                                                        <?php echo e(__($deposit->method_currency)); ?>

                                                        <br>
                                                        <strong>
                                                            <?php echo e(showAmount($deposit->final_amount, currencyFormat: false)); ?>

                                                            <?php echo e(__($deposit->method_currency)); ?>

                                                        </strong>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <?php echo $deposit->statusBadge ?>
                                                </td>
                                                <?php
                                                    $details = [];
                                                    if (
                                                        $deposit->method_code >= 1000 &&
                                                        $deposit->method_code <= 5000
                                                    ) {
                                                        foreach (@$deposit->detail ?? [] as $key => $info) {
                                                            $details[] = $info;
                                                            if ($info->type == 'file') {
                                                                $details[$key]->value = route(
                                                                    'restaurant.download.attachment',
                                                                    encrypt(getFilePath('verify') . '/' . $info->value),
                                                                );
                                                            }
                                                        }
                                                    }
                                                ?>
                                                <td>
                                                    <?php if($deposit->method_code >= 1000 && $deposit->method_code <= 5000): ?>
                                                        <a href="javascript:void(0)"
                                                            class="btn btn--sm btn--base btn-outline--base detailBtn"
                                                            data-info="<?php echo e(json_encode($details)); ?>"
                                                            <?php if($deposit->status == Status::PAYMENT_REJECT): ?> data-admin_feedback="<?php echo e($deposit->admin_feedback); ?>" <?php endif; ?>>
                                                            <i class="las la-desktop"></i>
                                                        </a>
                                                    <?php else: ?>
                                                        <a href="javascript:void(0)"
                                                            class="btn btn--sm btn--base btn-outline--base autoBtn"
                                                            data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Automatically processed'); ?>">
                                                            <i class="las la-check"></i>
                                                        </a>
                                                    <?php endif; ?>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="100%" class="empty-message"><?php echo e(__($emptyMessage)); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>

                            </div>
                        </div>
                        <?php if($deposits->hasPages()): ?>
                            <div class="card-footer">
                                <?php echo e(paginateLinks($deposits)); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div id="detailModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Details'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <ul class="list-group userData mb-2"></ul>
                    <div class="feedback"></div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .autoBtn {
            opacity: 0.7;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            (function($) {
                "use strict";
                $('.detailBtn').on('click', function() {
                    var modal = $('#detailModal');

                    var userData = $(this).data('info');

                    var html = '';
                    if (userData) {
                        userData.forEach(element => {
                            if (element.type != 'file') {
                                html += `
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <span>${element.name}</span>
                                    <span>${element.value}</span>
                                </li>`;
                            } else {
                                html += `
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <span>${element.name}</span>
                                    <span><a href="${element.value}"><i class="fa-regular fa-file"></i> <?php echo app('translator')->get('Attachment'); ?></a></span>
                                </li>`;
                            }
                        });
                    }

                    modal.find('.userData').html(html);

                    var adminFeedback = $(this).data('admin_feedback') !== undefined ? `
                        <div class="my-3">
                            <strong><?php echo app('translator')->get('Admin Feedback'); ?></strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    ` : '';

                    modal.find('.feedback').html(adminFeedback);

                    modal.modal('show');
                });

                var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
                var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                    return new bootstrap.Tooltip(tooltipTriggerEl);
                });
            })(jQuery);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'restaurant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/deposit_history.blade.php ENDPATH**/ ?>