<?php $__env->startSection('content'); ?>
    <div class="dashboard-table">
        <div class="dashbaord-table-header">
            <h6 class="card-header__title mb-0"><?php echo app('translator')->get('Orders'); ?> <i class="las la-shopping-cart text--base"></i></h6>
            <form class="search-form active">
                <input type="text" name="search" class="form--control" value="<?php echo e(request()->search); ?>"
                    placeholder="<?php echo app('translator')->get('Search by restaurant name'); ?>">
                <button type="submit" class="search-form__btn"><i class="las la-search"></i></button>
            </form>
        </div>


        <table class="table table--responsive--xl">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Restaurant name'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Price'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Payment'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Payment Type'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Status'); ?></th>
                    <th><?php echo app('translator')->get('Action'); ?></th>
                </tr>
            </thead>
            <tbody>

                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td lass="text-left">
                            <span class="fw-bold">
                                <a href="<?php echo e(route('restaurant.details', @$order->restaurant->slug)); ?>" class="text--base">
                                    <?php echo e(__(@$order->restaurant->restaurant_name)); ?>

                                </a>
                            </span>
                        </td>
                        <td class="text-center">
                            <?php echo e(showAmount($order->total_price)); ?>

                        </td>
                        <td class="text-center">
                            <?php echo $order->paymentData ?>
                        </td>

                        <td>
                            <?php echo $order->typeBadge ?>
                        </td>

                        <td class="text-center">
                            <?php echo $order->statusBadge ?>
                        </td>
                        <td>
                            <a class="btn btn--sm btn--base detailBtn" href="<?php echo e(route('user.order.details', $order->id)); ?>">
                                <i class="la la-desktop"></i>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php echo e(paginateLinks($orders)); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/user/order/index.blade.php ENDPATH**/ ?>