<?php $__env->startSection('content'); ?>
    <?php
        $orderTotalPrice = 0;
        $vat = $cartItems->first()->restaurant->vat;
        $deliveryFee = $cartItems->first()->restaurant->delivery_charge;
        $restaurant = $cartItems->first()->restaurant;
    ?>

    <div class="common-body section-bg-two pt-80 pb-80">
        <div class="container">
            <div class="row gy-4">
                <div class="col-xl-8 col-lg-8">
                    <form action="<?php echo e(route('user.order.submit')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo $__env->make($activeTemplate . 'partials.addresses', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <div class="additinal-note">
                            <h4><?php echo app('translator')->get('Additinal Note'); ?></h4>
                            <div class="col-12">
                                <div class="input-group">
                                    <input type="text" id="additional_notes" class="form-control form--control"
                                        name="additional_notes" placeholder="none">
                                    <label for="additional_notes"><?php echo app('translator')->get('Additinal Note'); ?></label>
                                </div>
                            </div>
                        </div>
                        <div class="payment">
                            <h4><?php echo app('translator')->get('Payment'); ?></h4>
                            <div class="bank-card">
                                <div class="row gy-4">
 

                                    <div class="col-xl-6">
                                        <div class="custom--radio bank-card-box">
                                            <input type="radio" value="1" id="cash" class="form-check-input"
                                                name="payment_type">
                                            <label for="cash">
                                                <i class="fas fa-money-bill-alt"></i>
                                                <?php echo app('translator')->get('Cash On Delivery'); ?>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn  btn--base w-100 btn--md"><?php echo app('translator')->get('Place Order'); ?></button>
                        </div>
                    </form>
                </div>
                <div class="col-xl-4 col-lg-4">
                    <div class="checkout-summary">
                        <p><?php echo app('translator')->get('Your Order Form'); ?> <a
                                href="<?php echo e(route('restaurant.details', $restaurant->slug)); ?>"><?php echo e(__($restaurant->restaurant_name)); ?></a>
                        </p>
                        <span class="pb-10">-<?php echo e(__($restaurant->location->name)); ?> </span>

                        <ul class="checkout-summary-item">
                            <?php $__currentLoopData = $cartItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $itemPrice = 0;
                                    $itemPrice = $itemPrice + $item->food->price;
                                    foreach ($item->variations ?? [] as $variationItemId) {
                                        $variationItem = App\Models\VariantItem::find($variationItemId);
                                        $itemPrice = $itemPrice + $variationItem->price;
                                    }
                                    foreach ($item->addons ?? [] as $addonsId) {
                                        $addonItem = App\Models\Addon::find($addonsId);
                                        $itemPrice = $itemPrice + $addonItem->price;
                                    }
                                    $itemPrice = $itemPrice * $item->quantity;
                                    $orderTotalPrice = $orderTotalPrice + $itemPrice;
                                ?>
                                <li><span><?php echo e(__($item->food->name)); ?></span>
                                    <span><?php echo e(showAmount($itemPrice)); ?></span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>

                        <ul class="checkout-summary-total">
                            <li><span><?php echo app('translator')->get('Subtotal'); ?></span>
                                <span><?php echo e(showAmount($orderTotalPrice)); ?></span>
                            </li>
                            <li><span><?php echo app('translator')->get('Delivery Fee'); ?></span>
                                <span><?php echo e(showAmount($deliveryFee)); ?></span>
                            </li>
                            <li><span><?php echo app('translator')->get('Vat'); ?></span>
                                <span><?php echo e(showAmount($orderTotalPrice * ($vat / 100))); ?></span>
                            </li>
                        </ul>
                        <ul class="total-payment">
                            <li class=""><span><?php echo app('translator')->get('Total'); ?>(<?php echo app('translator')->get('Incl'); ?>.<?php echo app('translator')->get('VAT'); ?>)</span>
                                <span><?php echo e(showAmount($orderTotalPrice + $deliveryFee + $orderTotalPrice * ($vat / 100))); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="addressModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="delivery-address-modal">
                            <div class="delivery-form">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" name="street" class="form-control form--control"
                                                    placeholder="none">
                                                <label for="name"><?php echo app('translator')->get('Street number'); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" name="apartment" class="form-control form--control"
                                                    placeholder="none">
                                                <label for="Apartment"><?php echo app('translator')->get('Apartment'); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="type">
                                </div>
                                <div class="delivcery-label">
                                    <h6><?php echo app('translator')->get('Select A Label'); ?></h6>
                                    <ul class="delivery-process">
                                        <li> <a href="javascript:void(0)" data-type="<?php echo e(Status::USER_ADDRESS_HOME); ?>"><i
                                                    class="las la-home"></i></a>
                                            <div class="delivery"><?php echo app('translator')->get('Home'); ?></div>
                                        </li>
                                        <li> <a href="javascript:void(0)" data-type="<?php echo e(Status::USER_ADDRESS_WORK); ?>"><i
                                                    class="las la-briefcase"></i></a>
                                            <div class="delivery"><?php echo app('translator')->get('Work'); ?></div>
                                        </li>
                                        <li> <a href="javascript:void(0)" data-type="<?php echo e(Status::USER_ADDRESS_OTHER); ?>"><i
                                                    class="las la-map-marker"></i></a>
                                            <div class="delivery"><?php echo app('translator')->get('Others'); ?></div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $(document).on('click', '.editAddressBtn', function() {
                var modal = $('#addressModal');
                var data = $(this).data('info');
                modal.find('.modal-title').text('Edit Modal');
                modal.find('form')[0].reset();
                modal.find('form').attr('action', $(this).data('url'));

                modal.find('input[name="street"]').val(data.street);
                modal.find('input[name="apartment"]').val(data.apartment);
                modal.find('input[name="type"]').val(data.type);

                $('.delivery-process li a').removeClass('active');
                $('.delivery-process li a[data-type="' + data.type + '"]').addClass('active');

                modal.modal('show');
            });

            $(document).on('click', '.addAddressBtn', function() {
                var modal = $('#addressModal');
                modal.find('.modal-title').text('Add Modal');
                modal.find('form')[0].reset();
                modal.find('form').attr('action', $(this).data('url'));
                modal.modal('show');
            });

            $(document).on('click', '.view-address button', function() {
                $('.delivery-address-box').removeClass('d-none');
                $('.edit-tag .select-address').removeClass('d-none');
                $('input[name="address_id"]').val(null);
                $('.view-address button').remove();
                notify('warning', 'Please select an address');
            });

            $(document).ready(function() {
                $('.delivery-process li a').on('click', function() {
                    $('.delivery-process li a').removeClass('active');
                    $(this).addClass('active');

                    var dataType = $(this).data('type');
                    $('input[name="type"]').val(dataType);
                });
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/user/checkout.blade.php ENDPATH**/ ?>