<?php if(@$cartItems && count($cartItems)): ?>
    <?php
        $orderTotalPrice = 0;
        $restaurant = $cartItems->first()->restaurant;
        $vat = $restaurant->vat;
        $deliveryFee = $restaurant->delivery_charge;
    ?>

    <div class="cross-btn d-block">
        <i class="fas fa-times"></i>
    </div>

    <div class="your-cart__form">
        <h4 class="your-cart__title"><?php echo app('translator')->get('Your cart'); ?></h4>
        <p><?php echo app('translator')->get('Your Order Form'); ?> <a class="text--base fw-bold"
                href="<?php echo e(route('restaurant.details', $restaurant->slug)); ?>"><?php echo e(__($restaurant->restaurant_name)); ?></a>
        </p>
    </div>
    <div class="your-cart__item your-cart__scroll">

        <?php $__currentLoopData = $cartItems ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $itemPrice = 0;
                $itemPrice = $itemPrice + $item->food->price;
                $details = '';
                foreach ($item->variations ?? [] as $variationItemId) {
                    $variationItem = App\Models\VariantItem::find($variationItemId);
                    $details .= $variationItem->name . ', ';
                    $itemPrice = $itemPrice + $variationItem->price;
                }
                foreach ($item->addons ?? [] as $addonsId) {
                    $addonItem = App\Models\Addon::find($addonsId);
                    $details .= $addonItem->name . ', ';
                    $itemPrice = $itemPrice + $addonItem->price;
                }
                $itemPrice = $itemPrice * $item->quantity;
                $orderTotalPrice = $orderTotalPrice + $itemPrice;
            ?>

            <div class="your-cart__item-single d-flex justify-content-between">
                <div class="your-cart__box d-flex">
                    <div class="your-cart__item-single-thumb">
                        <img src="<?php echo e(getImage(getFilePath('food') . '/thumb_' . $item->food->image, getFileThumbSize('food'))); ?>"
                            alt="img not found">
                    </div>
                    <div class="your-cart__item-single-content">
                        <h4><?php echo e(__($item->food->name)); ?></h4>
                        <span>
                            <?php echo e(__(rtrim($details, ', '))); ?>

                        </span>
                    </div>
                </div>
                <div class="your-cart__cunt">
                    <ul class="qnty-cart-list">
                        <li class="qnty-cart-list__item">
                            <div class="product-qty">
                                <button type="button" class="product-qty__btn product-qty__decrement cart-quantity-btn"
                                    data-id="<?php echo e($item->id); ?>" data-type="-"><i class="fas fa-minus"></i></button>
                                <input type="number" class="product-qty__value product-qty__btn cart-quantity"
                                    value="<?php echo e($item->quantity); ?>" data-id="<?php echo e($item->id); ?>">
                                <button type="button" class="product-qty__btn product-qty__increment cart-quantity-btn"
                                    data-id="<?php echo e($item->id); ?>" data-type="+"><i class="las la-plus"></i></button>
                            </div>
                        </li>
                    </ul>
                    <span><?php echo e(showAmount($itemPrice)); ?></span>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <div class="your-cart__item-total">
            <ul class="your-cart__amount pb-20">
                <li><span><?php echo app('translator')->get('Subtotal'); ?></span><span><?php echo e(showAmount($orderTotalPrice)); ?></span>
                </li>
                <li><span><?php echo app('translator')->get('Delivery Fee'); ?></span><span><?php echo e(showAmount($deliveryFee)); ?></span></li>
                <li><span><?php echo app('translator')->get('Vat'); ?></span><span><?php echo e(showAmount($orderTotalPrice * ($vat / 100))); ?></span>
                </li>
                <li><span><?php echo app('translator')->get('Total'); ?>(<?php echo app('translator')->get('Incl'); ?>.<?php echo app('translator')->get('VAT'); ?>)</span><span><?php echo e(showAmount($orderTotalPrice + $deliveryFee + $orderTotalPrice * ($vat / 100))); ?></span>
                </li>
            </ul>
            <div class="your-cart__item-right-btn">
                <?php if(auth()->guard()->check()): ?>
                    <a class="btn w-100 btn-location btn--base btn--md"
                        href="<?php echo e(route('user.order.checkout')); ?>"><?php echo app('translator')->get('Go to Chckout'); ?></a>
                <?php else: ?>
                    <button id="checkoutButton" class="btn w-100 btn-location btn--base btn--md">
                        <?php echo app('translator')->get('Go to Checkout'); ?>
                    </button>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php else: ?>
    
    <div class="cross-btn d-block">
        <i class="fas fa-times"></i>
    </div>
    <div class="your-cart__form">
        <h4 class="your-cart__title"><?php echo app('translator')->get('Your cart'); ?></h4>
        <div class="your-cart__form-icon">
            <img src="<?php echo e(getImage($activeTemplateTrue . 'images/cart.png')); ?>" alt="img not found">
        </div>
    </div>
    <div class="your-cart__item-total your-cart__item-border">
        <ul class="your-cart__amount pb-20">
            <li><span><?php echo app('translator')->get('Subtotal'); ?></span><span><?php echo e(showAmount(0.0)); ?></span></li>
            <li><span><?php echo app('translator')->get('Total'); ?>(<?php echo app('translator')->get('Incl'); ?>.<?php echo app('translator')->get('VAT'); ?>)</span><span><?php echo e(showAmount(0.0)); ?></span>
            </li>
        </ul>
        <div class="your-cart__item-right-btn">
            <button class="btn w-100 btn-disable btn--base btn--md"><?php echo app('translator')->get('Go to Checkout'); ?></button>
        </div>
    </div>
<?php endif; ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $(document).on("click", "#checkoutButton", function() {
                $('#cartLoginModal').modal('show');
                $(".your-cart").removeClass("active");
                $(".sidebar-overlay").removeClass("show");
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/partials/cart.blade.php ENDPATH**/ ?>