<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9"> <?php echo $__env->make($activeTemplate . 'restaurant.partials.food_progress_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> </div>
        </div>
        <form id="foodForm">
            <div class="card custom--card mt-5 mb-3">
                <div class="card-body">
                    <?php $__empty_1 = true; $__currentLoopData = $food->addons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="row addon-item">
                            <div class="col flex-input">
                                <div class="form-group">
                                    <label class="form-label required"><?php echo app('translator')->get('Name'); ?></label>
                                    <input type="text" name="addons[<?php echo e($addon->id); ?>][name]"
                                        class="form-control form--control" value="<?php echo e($addon->name); ?>" required>
                                </div>
                            </div>
                            <div class="col flex-input">
                                <div class="form-group">
                                    <label class="form-label required"><?php echo app('translator')->get('Price'); ?></label>
                                    <div class="input-group">
                                        <input type="number" class="form-control form--control"
                                            name="addons[<?php echo e($addon->id); ?>][price]"
                                            value="<?php echo e(showAmount($addon->price, currencyFormat: false)); ?>" required>
                                        <div class="input-group-text"><?php echo e(gs('cur_sym')); ?></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-auto">
                                <button class="btn btn--danger deleteAddonItem">
                                    <i class="las la-times" aria-hidden="true"></i>
                                </button>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="card-text text-center empty-message"><?php echo e($emptyMessage); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </form>
        <div class="d-flex justify-content-between">
            <button class="btn btn--base addAddons" type="button"> <?php echo app('translator')->get('Add Addons'); ?> <i class="las la-plus"></i>
            </button>

            <button class="btn btn--base" id="saveAndContinue" type="button"> <?php echo app('translator')->get('Save & Continue'); ?> <i
                    class="las la-angle-right"></i>
            </button>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        button.btn.btn--danger.deleteAddonItem {
            margin-top: 32px;
        }

        @media only screen and (max-width: 768px) {
            button.btn.btn--danger.deleteAddonItem {
                padding: 14px 6px;
            }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            function generateRandomNumber() {
                return Math.floor(Math.random() * (999999 - 100000 + 1)) + 100000;
            }

            function displayEmptyMessage() {
                if ($('.addon-item').length > 0) {
                    $('.empty-message').addClass('d-none');
                } else {
                    $('.empty-message').removeClass('d-none');
                }
            }

            function setAddonItemListners() {
                $('.deleteAddonItem').on('click', function(event) {
                    event.preventDefault(); // Prevent default form submission
                    var addonItem = $(this).closest('.addon-item');
                    addonItem.remove(); // Remove the closest addonItem item when delete button clicked
                    displayEmptyMessage();
                });
            }

            function setAddonListeners() {
                $('.addAddons').on('click', function(event) {
                    event.preventDefault(); // Prevent default form submission
                    var addonId = generateRandomNumber();
                    var addonItemHTML = `
                        <div class="row addon-item">
                            <div class="col flex-input">
                                <div class="form-group">
                                    <label class="form-label required"><?php echo app('translator')->get('Name'); ?></label>
                                    <input type="text" name="addons[${addonId}][name]" class="form-control form--control" required>
                                </div>
                            </div>

                            <div class="col flex-input">
                                <div class="form-group">
                                    <label class="form-label required"><?php echo app('translator')->get('Price'); ?></label>
                                    <div class="input-group">
                                        <input type="number" class="form-control form--control" name="addons[${addonId}][price]" required>
                                        <div class="input-group-text"><?php echo e(gs('cur_sym')); ?></div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-auto">
                                <button class="btn btn--danger deleteAddonItem">
                                    <i class="las la-times" aria-hidden="true"></i>
                                </button>
                            </div>
                        </div>
                    `

                    $('.card-body').append(addonItemHTML);
                    setAddonItemListners()
                    displayEmptyMessage();
                });
            }

            $(document).ready(function() {
                setAddonListeners()
                setAddonItemListners()
            });

            //Ajax
            $('#saveAndContinue').on('click', function() {
                var btn = $(this);
                var btnName = `<?php echo app('translator')->get('Save & Continue'); ?> <i class="las la-angle-right"></i>`;

                //store
                var formData = new FormData($('#foodForm')[0]);
                var url = '<?php echo e(route('restaurant.food.store.addons', @$food->id ?? '')); ?>';
                var token = '<?php echo e(csrf_token()); ?>';
                formData.append('_token', token);


                $.ajax({
                    url: url,
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        var btnAfterSubmit =
                            `<div class="spinner-border"></div> <?php echo app('translator')->get('Saving'); ?>...`;
                        btn.html(btnAfterSubmit);
                        btn.attr('disabled', true);
                    },
                    complete: function(e) {
                        btn.html(btnName);
                        btn.removeAttr('disabled');
                    },
                    success: function(response) {
                        if (response.success) {
                            if (!response.is_update) {
                                window.location.href = response.redirect_url
                            } else {
                                notify('success', `<?php echo app('translator')->get('Addons updated successfully'); ?>`);
                                btn.html(btnName);
                                btn.removeAttr('disabled');
                            }
                        } else {
                            notify('error', response.message);
                            btn.html(btnName);
                            btn.removeAttr('disabled');
                        }
                    },
                    error: function(xhr, status, error) {
                        notify('error', error);
                        btn.html(btnName);
                        btn.removeAttr('disabled');
                    }
                });

            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'restaurant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/food/addons.blade.php ENDPATH**/ ?>