

<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two sortable-table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Restaurant'); ?></th>
                                    <th><?php echo app('translator')->get('Plan'); ?></th>
                                    <th><?php echo app('translator')->get('Purchased'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                </tr>
                            </thead>
                            <tbody class="sort">
                                <?php $__empty_1 = true; $__currentLoopData = $restaurants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $restaurant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr class="sortable-table-row" data-id="<?php echo e($restaurant->id); ?>">
                                        <td><a
                                                href="<?php echo e(route('admin.restaurants.detail', $restaurant->id)); ?>"><?php echo e(__($restaurant->restaurant_name)); ?></a>
                                        </td>
                                        <td><?php echo e(__($restaurant->plan->name)); ?></td>
                                        <td><?php echo e(showDateTime($restaurant->plan_purchased_at)); ?> <br>
                                            <?php echo e(diffForHumans($restaurant->plan_purchased_at)); ?></td>
                                        <td> <?php echo $restaurant->planStatusBadge; ?> </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
            </div><!-- card end -->
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/table-sortable.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/jquery-ui.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/table-sortable.js')); ?>"></script>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        function updateSortOrder(sorting) {
            var action = "<?php echo e(route('admin.plan.restaurant.sort')); ?>";
            var csrf = "<?php echo e(csrf_token()); ?>";
            sortOrderAction(sorting, action, csrf);
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/admin/plan/restaurants.blade.php ENDPATH**/ ?>