<?php
    $pages = App\Models\Page::where('tempname', $activeTemplate)
        ->where('is_default', Status::NO)
        ->get();
    $isPages = $pages->count() > 1;

    $user = auth()->user();
    $cartUrl = null;

    // Check if user is authenticated and fetch current order
    if ($user) {
        $currentOrder = App\Models\Order::userOrders()
            ->whereIn('status', [Status::ORDER_PROCESSING, Status::ORDER_ON_DELIVERY])
            ->latest()
            ->first();
    }

    $sessionId = $user ? 0 : Session::get('session_id');

    $cartItemsQuery = \App\Models\Cart::with('user', 'restaurant', 'food');
    if ($user) {
        $cartItemsQuery->where('user_id', $user->id);
    } else {
        $cartItemsQuery->where('session_id', $sessionId);
    }
    $cartItems = $cartItemsQuery->get();
    
    // Determine cart URL based on authentication status
    $cartCount = 0;
    if (request()->routeIs('restaurant.details')) {
        if ($user) {
            // If the user is authenticated
            if (@$restaurant->id == @userInfo()['cart_restaurant_id']) {
                $cartUrl = 'javascript:void(0)';
            } else {
                $cartUrl = @userInfo()['cart_link'];
            }
            $cartCount = @userInfo()['cart_count'] ?? 0;
        } else {
            // For unauthenticated users, find the cart items using the session ID
            $sessionId = Session::get('session_id');
            $cartItemsQuery = App\Models\Cart::where('session_id', $sessionId)->with('restaurant');
            $cartCount = $cartItemsQuery->count();
            $cartItem = $cartItemsQuery->first();

            if ($cartItem && @$restaurant->id == @$cartItem->restaurant->id) {
                $cartUrl = 'javascript:void(0)';
            } else {
                $cartUrl =
                    $cartCount > 0 ? route('restaurant.details', @$cartItem->restaurant->slug) : 'javascript:void(0)';
            }
        }
    } else {
        if ($user) {
            $cartUrl = @userInfo()['cart_link'];
            $cartCount = @userInfo()['cart_count'] ?? 0;
        } else {
            $sessionId = Session::get('session_id');
            $cartItemsQuery = App\Models\Cart::where('session_id', $sessionId)->with('restaurant');
            $cartCount = $cartItemsQuery->count();
            $cartItem = $cartItemsQuery->first();
            $cartUrl =
                $cartCount > 0 ? route('restaurant.details', @$cartItem->restaurant->slug) : 'javascript:void(0)';
        }
    }

    $authenticatedUser = authenticatedUser();
?>

<div class="header-area">
    <div class="header-main" id="header-sticky">
        <div class="container custom-container">
            <div class="row align-items-center ">
                <div class="col-xl-2 col-lg-2 col-md-2 col-sm-3 col-12 d-flex justify-content-between">
                    <div class="logo">
                        <a href="<?php echo e(route('home')); ?>" class="logo-w"><img src="<?php echo e(siteLogo()); ?>" alt="logo-img"></a>
                    </div>
                    <div class="menu-bar d-sm-none">
                        <a class="side-toggle" href="javascript:void(0)">
                            <div class="bar-icon">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </a>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-4  d-none d-xl-block">
                    <div class="main-menu-wrapper">
                        <div class="main-menu-inner d-flex align-items-center ">
                            <div class="menumain">
                                <nav id="mobile-menu">
                                    <ul>
                                        <li>
                                            <a class="link-item <?php echo e(menuActive('home')); ?>"
                                                href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                                        </li>
                                        <?php if(auth()->guard()->check()): ?>
                                            <li class="has-dropdown">
                                                <a class="link-item <?php echo e(menuActive(['all.restaurants', 'favorite.restaurants'])); ?>"
                                                    href="javascript:void(0)"><?php echo app('translator')->get('Restaurants'); ?></a>
                                                <ul class="submenu">
                                                    <li><a href="<?php echo e(route('search')); ?>"><?php echo app('translator')->get('All Restaurants'); ?></a>
                                                    </li>
                                                    <li><a href="<?php echo e(route('favorite.restaurants')); ?>"><?php echo app('translator')->get('Favorite Restaurants'); ?></a>
                                                    </li>
                                                </ul>
                                            </li>
                                        <?php else: ?>
                                            <li>
                                                <a class="link-item <?php echo e(menuActive(['all.restaurants', 'search'])); ?>"
                                                    href="<?php echo e(route('search')); ?>"><?php echo app('translator')->get('Restaurants'); ?></a>
                                            </li>
                                        <?php endif; ?>

                                        <?php if(!$isPages && $pages->first()): ?>
                                            <li>
                                                <a class="link-item <?php echo e(menuActive('pages', [$pages->first()->slug])); ?>"
                                                    href="<?php echo e(route('pages', [$pages->first()->slug])); ?>"><?php echo e(__($pages->first()->name)); ?></a>
                                            </li>
                                        <?php endif; ?>
                                        <li>
                                            <a class="link-item <?php echo e(menuActive('contact')); ?>"
                                                href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                                        </li>

                                        <?php if($isPages): ?>
                                            <li class="has-dropdown">
                                                <a class="link-item <?php echo e(menuActive('pages')); ?>"
                                                    href="javascript:void(0)"><?php echo app('translator')->get('Pages'); ?></a>
                                                <ul class="submenu">
                                                    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li>
                                                            <a
                                                                href="<?php echo e(route('pages', [$page->slug])); ?>"><?php echo e(__($page->name)); ?></a>
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </li>
                                        <?php endif; ?>

                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-10 col-md-10 col-sm-9 col-12 d-xl-block">
                    <div
                        class="header-area-right d-flex align-items-center justify-content-center justify-content-sm-end cart-menu-none">

                        <?php echo $__env->make($activeTemplate . 'partials.header.current_order', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <?php echo $__env->make($activeTemplate . 'partials.header.cart_favorite', [
                            'cartUrl' => $cartUrl,
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <div class="d-none d-lg-block">
                            <div class="header-area-right__featurs d-flex  align-items-center">
                                <div class="theme-switch-wrapper">
                                    <label class="theme-switch" for="checkbox2">
                                        <input type="checkbox" id="checkbox2" class="d-none">
                                        <span class="slider round"></span>
                                    </label>
                                </div>

                                <?php echo $__env->make($activeTemplate . 'partials.header.language_box', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                            </div>
                        </div>

                        <div class="nav-right-profile d-none d-lg-block">
                            <ul class="prfile-menu">
                                <li>
                                    <?php echo $__env->make($activeTemplate . 'partials.header.user_profile_dropdown', [
                                        'authenticatedUser' => $authenticatedUser,
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            </ul>
                        </div>
                        <div class="menu-bar menu-bar-sm  d-xl-none">
                            <a class="side-toggle" href="javascript:void(0)">
                                <div class="bar-icon">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- header area end -->

<div
    class="header-area-right d-flex align-items-center justify-content-center justify-content-sm-end cart-menu d-block d-sm-none ">
    <?php echo $__env->make($activeTemplate . 'partials.header.current_order_mobile_view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make($activeTemplate . 'partials.header.cart_favorite', ['cartUrl' => $cartUrl], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php echo $__env->make($activeTemplate . 'partials.header.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/partials/header.blade.php ENDPATH**/ ?>