<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'isSection' => false,
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'isSection' => false,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<?php
    $restaurantLink = '#';
    $foodName = __(strLimit($food->name, 16));
    $foodDescription = __(strLimit($food->short_description, 52));
    if ($isSection) {
        $restaurant = $food->restaurant;
        $foodName = __(strLimit($food->name, 24));
        $restaurantLink = route('restaurant.details', $restaurant->slug);
        $foodDescription = strLimit($foodDescription, 32);
        $class = 'food-section';
    }
?>

<div class="popular-food__item popular-food__item-style2 d-flex <?php echo e(@$class); ?>">
    <input type="hidden" data-food='<?php echo json_encode($food, 15, 512) ?>' class="foodData">
    <button class="heart <?php echo e(foodIsFavorite($food)); ?>" data-url=<?php echo e(route('food.favorite', $food->id)); ?>><i
            class="far fa-heart"></i></button>
    <?php if(!$isSection): ?>
        <button class="add" data-bs-toggle="modal" data-bs-target="#foodcart"><i class="las la-plus"></i></button>
    <?php endif; ?>

    <div class="popular-food__item-thumb">
        <a href="<?php echo e($restaurantLink); ?>"><img
                src="<?php echo e(getImage(getFilePath('food') . '/thumb_' . $food->image, getFileThumbSize('food'))); ?>"
                alt="img not found"></a>
    </div>
    <div class="popular-food__item-meta">
        <div class="popular-food__item-meta-content">
            <h4 class="title">
                <a href="<?php echo e($restaurantLink); ?>"
                    <?php if(!$isSection): ?> data-bs-toggle="modal"
                        data-bs-target="#foodcart" <?php endif; ?>>
                    <?php echo e(__($foodName)); ?>

                </a>
            </h4>
            <?php if($isSection): ?>
                <p class="subtitle mt-2 mb-3"><i class="fas fa-utensils me-1"></i>
                    <?php echo e(__($restaurant->restaurant_name)); ?>

                </p>
            <?php else: ?>
                <p class="subtitle mt-2 mb-3"><i class="fas fa-utensils me-1"></i>
                    <?php echo e($foodDescription); ?>

                </p>
            <?php endif; ?>

            <span class="price-range"><?php echo app('translator')->get('Form'); ?> <?php echo e(__(showAmount($food->price))); ?></span>
        </div>
    </div>
</div>
<?php /**PATH /home/braixses/aklooo.com/core/resources/views/components/food.blade.php ENDPATH**/ ?>