<?php $activeAddress = $addresses->where('status', Status::ENABLE)->first(); ?>
<div class="delivery-address">
    <div class="delivery-address__inner">
        <h4 class="title"><?php echo app('translator')->get('Delivery Address'); ?> <button type="button" class="addAddressBtn"
                data-url='<?php echo e(route('user.address.update')); ?>'>+
                <?php echo app('translator')->get('Add Address'); ?></button></h4>

        <?php if($activeAddress): ?>
            <div class="delivery-address-box">
                <input type="hidden" name="address_id" value="<?php echo e(@$activeAddress->id); ?>">
                <div class="edit-tag">
                    <div class="d-inline-block select-address d-none">
                        <a href="<?php echo e(route('user.address.select', $activeAddress->id)); ?>" data-toggle="tooltip"
                            data-placement="top" title="Select Address" class="pencil">
                            <i class="las la-check"></i>
                        </a>
                    </div>
                    <div class="d-inline-block">
                        <button class="editAddressBtn" type="button" data-toggle="tooltip" data-placement="top"
                            title="Edit Address" data-url='<?php echo e(route('user.address.update', $activeAddress->id)); ?>'
                            class="pencil" data-info="<?php echo e($activeAddress); ?>"><i class="las la-pen"></i>
                        </button>
                    </div>
                    <div class="d-inline-block delete">
                        <button type="button" data-toggle="tooltip" data-placement="top" title="Delete Address"
                            data-question="<?php echo app('translator')->get('Are you sure to delete this address?'); ?>"
                            data-action='<?php echo e(route('user.address.delete', $activeAddress->id)); ?>'
                            class="trash-can confirmationBtn"><i class="las la-trash-alt"></i>
                        </button>
                    </div>
                </div>
                <h6><a
                        href="<?php echo e(route('user.address.select', $activeAddress->id)); ?>"><?php echo e(__(@$activeAddress->addressType())); ?></a>
                </h6>
                <p>
                    <a href="<?php echo e(route('user.address.select', $activeAddress->id)); ?>"><?php echo e(__(@$activeAddress->apartment)); ?>,
                        <?php echo e(__(@$activeAddress->street)); ?></a>
                </p>
            </div>

            <?php
                $inActiveAddresses = $addresses->where('id', '!=', $activeAddress->id);
            ?>

            <?php $__currentLoopData = $inActiveAddresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="delivery-address-box d-none">
                    <div class="edit-tag">
                        <div class="d-inline-block">
                            <a href="<?php echo e(route('user.address.select', $address->id)); ?>" data-toggle="tooltip"
                                data-placement="top" title="Select Address" class="pencil">
                                <i class="las la-check"></i>
                            </a>
                        </div>
                        <div class="d-inline-block">
                            <button class="editAddressBtn" type="button" data-toggle="tooltip" data-placement="top"
                                title="Edit Address" data-url='<?php echo e(route('user.address.update', $address->id)); ?>'
                                class="pencil" data-url='<?php echo e(route('user.address.update', $address->id)); ?>'
                                data-info="<?php echo e($address); ?>"><i class="las la-pen"></i>
                            </button>
                        </div>
                        <div class="d-inline-block delete">
                            <button type="button" data-question="<?php echo app('translator')->get('Are you sure to delete this address?'); ?>" data-toggle="tooltip"
                                data-placement="top" title="Delete Address"
                                data-action='<?php echo e(route('user.address.delete', $address->id)); ?>'
                                class="trash-can confirmationBtn"><i class="las la-trash-alt"></i>
                            </button>
                        </div>
                    </div>
                    <h6>
                        <a href="<?php echo e(route('user.address.select', $address->id)); ?>">
                            <?php echo e(__(@$address->addressType())); ?>

                        </a>
                    </h6>
                    <p>
                        <a href="<?php echo e(route('user.address.select', $address->id)); ?>">
                            <?php echo e(__(@$address->apartment)); ?>, <?php echo e(__(@$address->street)); ?>

                        </a>
                    </p>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>


        <?php if(count($addresses) > 1): ?>
            <div class="view-address">
                <button><?php echo app('translator')->get('View Saved Address'); ?></button>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/partials/addresses.blade.php ENDPATH**/ ?>