<?php $__env->startSection('content'); ?>
    <div class="py-70">
        <div class="container">
            <div class="row justify-content-center mt-2">
                <div class="col-lg-12 ">
                    <div class="dashboard-table">
                        <div class="dashbaord-table-header">
                            <h6 class="card-header__title mb-0"><?php echo e($pageTitle); ?> <i
                                    class="las la-hamburger text--base"></i></h6>
                            <form class="search-form active">
                                <input type="text" name="search" class="form--control" value="<?php echo e(request()->search); ?>"
                                    placeholder="<?php echo app('translator')->get('Search here'); ?>...">
                                <button type="submit" class="search-form__btn"><i class="las la-search"></i></button>
                            </form>
                        </div>

                        <table class="table table--responsive--lg">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Image'); ?></th>
                                    <th><?php echo app('translator')->get('Name'); ?></th>
                                    <th><?php echo app('translator')->get('Description'); ?></th>
                                    <th><?php echo app('translator')->get('Price'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $foods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $food): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div class="user-info__thumb">
                                                <img src="<?php echo e(getImage(getFilePath('food') . '/thumb_' . $food->image, getFileThumbSize('food'))); ?>"
                                                    class="fit-image" alt="img not found">
                                            </div>
                                        </td>
                                        <td>
                                            <?php echo e(__($food->name)); ?>

                                        </td>
                                        <td>
                                            <?php echo e(__(strLimit($food->short_description))); ?>

                                        </td>
                                        <td>
                                            <?php echo e(showAmount($food->price)); ?>

                                        </td>
                                        <td>
                                            <?php echo $food->statusBadge ?>
                                        </td>
                                        <td>
                                            <div class="d-flex flex-wrap gap-2 justify-content-end">
                                                <a href="<?php echo e(route('restaurant.food.overview', $food->id)); ?>"
                                                    class="btn btn--sm btn--base btn-outline--base btn--sm">
                                                    <i class="la la-pen"></i>
                                                </a>

                                                <?php if($food->status == Status::FOOD_DRAFT): ?>
                                                    <button
                                                        class="btn btn--sm btn-outline--success ms-1 confirmationBtn btn--sm"
                                                        data-question="<?php echo app('translator')->get('Are you sure to publish this food?'); ?>"
                                                        data-action="<?php echo e(route('restaurant.food.status', $food->id)); ?>">
                                                        <i class="la la-eye"></i> <?php echo app('translator')->get('Publish'); ?>
                                                    </button>
                                                <?php else: ?>
                                                    <button
                                                        class="btn btn--sm btn-outline--danger ms-1 confirmationBtn btn--sm"
                                                        data-question="<?php echo app('translator')->get('Are you sure to draft this food?'); ?>"
                                                        data-action="<?php echo e(route('restaurant.food.status', $food->id)); ?>">
                                                        <i class="la la-eye-slash"></i> <?php echo app('translator')->get('Draft'); ?>
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted empty-message" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        <?php if($foods->hasPages()): ?>
                            <?php echo e(paginateLinks($foods)); ?>

                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'restaurant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/food/index.blade.php ENDPATH**/ ?>