<?php $__env->startSection('content'); ?>
    <div class="py-70">
        <div class="container">
            <div class="row justify-content-center mt-2">
                <div class="col-lg-12 ">
                    <div class="dashboard-table">
                        <div class="dashbaord-table-header">
                            <h6 class="card-header__title mb-0"><?php echo app('translator')->get('Categories'); ?> <i
                                    class="las la-file-invoice-dollar text--base"></i></h6>
                            <form class="search-form active">
                                <input type="text" name="search" class="form--control" value="<?php echo e(request()->search); ?>"
                                    placeholder="<?php echo app('translator')->get('Search here'); ?>...">
                                <button type="submit" class="search-form__btn"><i class="las la-search"></i></button>
                            </form>
                        </div>

                        <table class="table table--responsive--lg">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Name'); ?></th>
                                    <th><?php echo app('translator')->get('Foods'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <span class="fw-bold"><span class="text--base">
                                                    <?php echo e(__(@$category->name)); ?></span></span>
                                        </td>
                                        <td>
                                            <?php echo e($category->foods_count); ?>

                                        </td>
                                        <td>
                                            <?php echo $category->statusBadge ?>
                                        </td>
                                        <td>

                                            <button class="btn btn--sm btn--base btn-outline--base editBtn"
                                                data-id="<?php echo e($category->id); ?>" data-name="<?php echo e($category->name); ?>">
                                                <i class="la la-pen"></i>
                                            </button>

                                            <?php if($category->status == Status::DISABLE): ?>
                                                <button class="btn btn--sm btn-outline--success ms-1 confirmationBtn"
                                                    data-question="<?php echo app('translator')->get('Are you sure to enable this category?'); ?>"
                                                    data-action="<?php echo e(route('restaurant.category.status', $category->id)); ?>">
                                                    <i class="la la-eye"></i> <?php echo app('translator')->get('Enable'); ?>
                                                </button>
                                            <?php else: ?>
                                                <button class="btn btn--sm btn-outline--danger ms-1 confirmationBtn"
                                                    data-question="<?php echo app('translator')->get('Are you sure to disable this category?'); ?>"
                                                    data-action="<?php echo e(route('restaurant.category.status', $category->id)); ?>">
                                                    <i class="la la-eye-slash"></i> <?php echo app('translator')->get('Disable'); ?>
                                                </button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted empty-message" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="detailModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form id="myForm" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo app('translator')->get('Details'); ?></h5>
                        <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </span>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="form-label required"><?php echo app('translator')->get('Name'); ?></label>
                            <input type="text" class="form-control form--control" name="name" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <button class="btn btn--base addBtn"><?php echo app('translator')->get('Add Category'); ?></button>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            var url = '<?php echo e(route('restaurant.category.store')); ?>';
            $('.addBtn').on('click', function() {
                var modal = $('#detailModal');
                modal.find('form')[0].reset();
                $('#myForm').attr('action', url);
                modal.modal('show');
            });

            $('.editBtn').on('click', function() {
                var modal = $('#detailModal');
                modal.find('form')[0].reset();
                var categoryId = $(this).data('id');
                var categoryName = $(this).data('name');

                $('#myForm').attr('action', url + '/' + categoryId);
                $('input[name="name"]').val(categoryName);

                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'restaurant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/categories.blade.php ENDPATH**/ ?>