<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--lg  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Image'); ?></th>
                                    <th><?php echo app('translator')->get('Size'); ?></th>
                                    <th><?php echo app('translator')->get('Impression'); ?></th>
                                    <th><?php echo app('translator')->get('Click'); ?></th>
                                    <th><?php echo app('translator')->get('Redirect'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $advertisements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $advertisement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div class="thumb avatar avatar--md">
                                                <img id="image__<?php echo e($advertisement->id); ?>"
                                                    src="<?php echo e(getImage(getFilePath('advertisement') . '/' . @$advertisement->value)); ?>"
                                                    alt="img not found">
                                            </div>
                                        </td>
                                        <td>
                                            <?php echo e(__(@$advertisement->size)); ?>

                                        </td>
                                        <td>
                                            <span class="badge badge--success"> <?php echo e(@$advertisement->impression); ?></span>
                                        </td>
                                        <td>
                                            <span class="badge badge--primary">
                                                <?php echo e(@$advertisement->click); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <?php if($advertisement->redirect_url): ?>
                                                <a target="_blank" href="<?php echo e(@$advertisement->redirect_url); ?>">
                                                    <?php echo e(@strLimit($advertisement->redirect_url, 30)); ?>

                                                </a>
                                            <?php else: ?>
                                                ---
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo $advertisement->statusBadge ?>
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                <button
                                                    data-advertisement="<?php echo e(json_encode($advertisement->only('id', 'type', 'value', 'size', 'redirect_url', 'status'))); ?>"
                                                    data-url = "<?php echo e(route('admin.advertisement.store', $advertisement->id)); ?>"
                                                    class="btn btn-sm btn-outline--primary ms-1 editBtn"><i
                                                        class="las la-pen"></i> <?php echo app('translator')->get('Edit'); ?></button>
                                                <?php if($advertisement->status == Status::ENABLE): ?>
                                                    <button class="btn btn-sm btn-outline--danger ms-1 confirmationBtn"
                                                        data-question="<?php echo app('translator')->get('Are you sure to disable this advertisement?'); ?>"
                                                        data-action="<?php echo e(route('admin.advertisement.status', $advertisement->id)); ?>">
                                                        <i class="la la-eye-slash"></i> <?php echo app('translator')->get('Disable'); ?>
                                                    </button>
                                                <?php else: ?>
                                                    <button class="btn btn-sm btn-outline--success ms-1 confirmationBtn"
                                                        data-question="<?php echo app('translator')->get('Are you sure to enable this advertisement?'); ?>"
                                                        data-action="<?php echo e(route('admin.advertisement.status', $advertisement->id)); ?>">
                                                        <i class="la la-eye"></i> <?php echo app('translator')->get('Enable'); ?>
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <?php if($advertisements->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($advertisement)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div id="advertisementModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for=""><?php echo app('translator')->get('Size'); ?></label>
                                    <select class="form-control form--control" id="size" name="size" required>
                                        <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                        <?php $__currentLoopData = adsSizes(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($size); ?>"><?php echo e($size); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group" id="imageDiv">
                                    <label><?php echo app('translator')->get('Image'); ?></label>
                                    <?php if (isset($component)) { $__componentOriginaldbcc027cdd3569f61821c56d10b77c01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.image-uploader','data' => ['image' => '','class' => 'w-100','type' => 'advertisement','required' => false,'size' => '370X670']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('image-uploader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['image' => '','class' => 'w-100','type' => 'advertisement','required' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'size' => '370X670']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $attributes = $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $component = $__componentOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
                                </div>
                                <div class="form-group">
                                    <label for=""><?php echo app('translator')->get('Redirect Url'); ?></label>
                                    <input type="text" class="form-control form--control" name="redirect_url"
                                        placeholder="<?php echo app('translator')->get('Redirect Url'); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <button type="button" data-route="<?php echo e(route('admin.advertisement.store')); ?>" data-bs-target="#advertisementModal"
        data-bs-toggle="modal" class="btn btn-sm btn-outline--primary addBtn"
        data-url="<?php echo e(route('admin.advertisement.store')); ?>"><i class="las la-plus"></i><?php echo app('translator')->get('Add New'); ?></button>
<?php $__env->stopPush(); ?>



<?php $__env->startPush('script'); ?>
    <script>
        $(function($) {
            "use strict";
            var modal = $('#advertisementModal');

            $('.editBtn').on('click', function() {
                var advertisementData = $(this).data('advertisement');
                var url = $(this).data('url');
                var filePath = "<?php echo e(route('home') . '/' . getFilePath('advertisement')); ?>";

                modal.find('.modal-title').text("<?php echo app('translator')->get('Edit Advertisement'); ?>");
                modal.find('form').attr('action', url);

                // Populate form fields with advertisement data
                $('#size').val(advertisementData.size);
                $('#redirect_url').val(advertisementData.redirect_url);

                // Show/hide appropriate div based on type
                var image = advertisementData.value;
                if (image) {
                    var imageUrl = filePath + '/' + image;
                } else {
                    var imageUrl = '<?php echo e(getImage('')); ?>';
                }

                $(".image-upload-preview").css({
                    "background-image": "url('" + imageUrl + "')"
                });


                modal.modal('show');
                $('#size').change();
            });

            $('.addBtn').on('click', function() {
                modal.find('.modal-title').text("<?php echo app('translator')->get('Add Advertisement'); ?>");
                modal.find('form')[0].reset();
                modal.find('form').attr('action', $(this).data('route'));
                var imageUrl = '<?php echo e(getImage('')); ?>';
                $(".image-upload-preview").css({
                    "background-image": "url('" + imageUrl + "')"
                });
                $('#type').change();
                $('#size').change();
            });
        });

        $('#size').on('change', function() {
            var selectedSize = $(this).val();
            if (!selectedSize) {
                $('#imageDiv .text-muted').hide();
            } else {
                $('#imageDiv .text-muted').show();
                $('#imageDiv small b:last-child').html(selectedSize);
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/admin/advertisement/index.blade.php ENDPATH**/ ?>