<?php $__env->startSection('panel'); ?>
    <section class="refund">
        <div class="container">
            <div class="row gy-4 justify-content-center">
                <div class="col-xl-7 col-lg-7 col-md-10">
                    <div class="card custom--card refund-section">
                        <div class="refund-fund d-flex justify-content-between">
                            <div class="refund-fund-left">
                                <span><?php echo app('translator')->get('Total Price'); ?></span>
                                <h4 class="refund-fund-title">
                                    <?php echo e(showAmount($order->total_price)); ?>

                                </h4>
                            </div>
                        </div>
                        <div class="refund-order">
                            <h4><i class="fas fa-receipt"></i><?php echo app('translator')->get('Order Items'); ?> <?php if($order->status == Status::ORDER_CANCELLED): ?>
                                    <span class="text--danger">(<?php echo app('translator')->get('Cancelled'); ?>)</span>
                                <?php endif; ?>
                            </h4>
                        </div>
                        <?php $subTotal = 0; ?>
                        <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $subTotal = $subTotal + $item->total_price; ?>
                            <div class="accordion custom--accordion" id="accordionExample<?php echo e('accordionItem' . $key); ?>">
                                <div class="accordion-item">
                                    <div class="accordion-header" id="headingOne<?php echo e('accordionItem' . $key); ?>">
                                        <div class="accordion-button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseOne<?php echo e('accordionItem' . $key); ?>" aria-expanded="true"
                                            aria-controls="collapseOne<?php echo e('accordionItem' . $key); ?>">
                                            <div class="refund-according">
                                                <span><?php echo e(showDateTime($item->created_at)); ?></span>
                                            </div>
                                            <div class="refund-according">
                                                <h4><?php echo e(__($item->food->name)); ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="collapseOne<?php echo e('accordionItem' . $key); ?>"
                                        class="accordion-collapse collapse show"
                                        aria-labelledby="headingOne<?php echo e('accordionItem' . $key); ?>"
                                        data-bs-parent="#accordionExample<?php echo e('accordionItem' . $key); ?>" style="">
                                        <div class="accordion-body pt-4">
                                            <div class="accordion-body__order">
                                                <ul class="accordion-body__list">
                                                    <li>
                                                        <span><?php echo app('translator')->get('Item Price'); ?></span>
                                                        <span><?php echo e(showAmount($item->item_price)); ?></span>
                                                    </li>
                                                    <li><span><?php echo app('translator')->get('Quantity'); ?></span>
                                                        <span><?php echo e($item->quantity); ?></span>
                                                    </li>
                                                    <?php if($item->variations): ?>
                                                        <li><span class="title">Variants:</span></li>
                                                        <?php $__currentLoopData = $item->variations ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li><span><?php echo e(__($variation[0])); ?></span>
                                                                <span><?php echo e(showAmount($variation[1])); ?></span>
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>

                                                    <?php if($item->addons): ?>
                                                        <li><span class="title">Addons:</span></li>
                                                        <?php $__currentLoopData = $item->addons ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li><span><?php echo e(__($addon[0])); ?></span>
                                                                <span><?php echo e(showAmount($addon[1])); ?></span>
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>

                                                    <?php if($item->additional_notes): ?>
                                                        <li>
                                                            <span class="title"><?php echo app('translator')->get('Additional Notes'); ?>:</span>
                                                        </li>
                                                        <li>
                                                            <span><?php echo e(__($item->additional_notes)); ?></span>
                                                        </li>
                                                    <?php endif; ?>

                                                </ul>
                                                <ul class="accordion-body__total">
                                                    <li class="title"><span><?php echo app('translator')->get('Subtotal'); ?></span>
                                                        <span><?php echo e(showAmount($item->total_price)); ?></span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <div class="order-details-address">
                            <label for=""><?php echo app('translator')->get('Order Address'); ?>:</label>
                            <p><?php echo e(__($order->address)); ?></p>
                        </div>

                        <div class="order-details-total">
                            <ul class="accordion-body__price">
                                <li>
                                    <span><?php echo app('translator')->get('Status'); ?></span>
                                    <span><?php echo $order->statusBadge ?></span>
                                </li>
                                <li><span><?php echo app('translator')->get('Payment Type'); ?></span><span><?php echo $order->typeBadge ?></span></li>
                                <li><span><?php echo app('translator')->get('Subtotal'); ?></span><span><?php echo e(showAmount($subTotal)); ?></span>
                                </li>
                                <li><span><?php echo app('translator')->get('Vat'); ?></span><span><?php echo e(showAmount($order->vat)); ?></span>
                                </li>
                                <li><span><?php echo app('translator')->get('Delivery Fee'); ?></span><span><?php echo e(showAmount($order->delivery_charge)); ?></span>
                                </li>
                            </ul>
                            <ul class="accordion-body__total">
                                <li class="total">
                                    <span><?php echo app('translator')->get('Total'); ?></span>
                                    <span><?php echo e(showAmount($order->total_price)); ?></span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/admin/order/details.blade.php ENDPATH**/ ?>