
<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9"> <?php echo $__env->make($activeTemplate . 'restaurant.partials.food_progress_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> </div>
        </div>
        <form id="foodForm">
            <div class="card custom--card mt-5 mb-3 variant">
                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-lg-9">
                            <div class="food-publish text-center">
                                <div class="food-publish-icon text--base">
                                    <i class="far fa-check-circle"></i>
                                </div>
                                <?php if($food->status == Status::FOOD_PUBLISHED): ?>
                                    <h5 class="mb-0 draft-notify"><?php echo app('translator')->get('Congratulations! Food is published.'); ?></h5>
                                <?php else: ?>
                                    <h5 class="mb-3 published-notify"> <?php echo app('translator')->get('Almost Ready for Publishing'); ?></h5>
                                    <p class="mb-3 info"><?php echo app('translator')->get('Your anticipation is appreciated as we put the finishing touches on the food item. Are you ready to publish?'); ?></p>
                                    <button class="btn btn--base" id="foodPublished"
                                        type="button"><?php echo app('translator')->get('Publish Your Food Now'); ?></button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        button.btn.btn--danger.deleteVariantItem {
            margin-top: 32px;
        }

        @media only screen and (max-width: 768px) {
            button.btn.btn--danger.deleteVariantItem {
                padding: 14px 6px;
            }
        }

        .deleteVariant {
            position: absolute;
            top: 0px;
            right: 0;
            padding: 2px;
            border-radius: 50%;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('#saveAndDraft').on('click', function() {
                foodFinalAction(0, $(this));
            });

            $('#foodPublished').on('click', function() {
                foodFinalAction(1, $(this));
            });

            function foodFinalAction(isPublished, btn) {
                var btnText = btn.text();
                var spinnerHtml = '<div class="spinner-border"></div>';
                var url = '<?php echo e(route('restaurant.food.store.publish', $food->id)); ?>';
                var token = '<?php echo e(csrf_token()); ?>';

                btn.attr('disabled', true);

                var data = {
                    is_published: isPublished,
                    _token: token
                };

                $.ajax({
                    url: url,
                    method: 'POST',
                    data: data,
                    beforeSend: function() {
                        btn.html(spinnerHtml + ' ' + (isPublished ? '<?php echo app('translator')->get('Publishing'); ?>' :
                            '<?php echo app('translator')->get('Drafting'); ?>') + '...');
                        btn.attr('disabled', true);
                    },
                    complete: function(e) {
                        btn.html(btnText);
                        btn.removeAttr('disabled');
                    },
                    success: function(response) {
                        if (response.success) {
                            if (response.status == 0) {
                                notify('success', `<?php echo app('translator')->get('Food save and drafted successfully'); ?>`);
                                $('.draft-notify').text(`<?php echo app('translator')->get('Food is Drafted'); ?>`);
                            } else {
                                $('.published-notify').text(`<?php echo app('translator')->get('Congratulations!'); ?>`);
                            }
                            setTimeout(() => {
                                btn.hide();
                                $('.info').hide();
                                window.location.href = response.redirect_url;
                            }, 1000);
                        } else {
                            notify('error', response.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        notify('error', error);
                        btn.html(btnText);
                        btn.removeAttr('disabled');
                    }
                });

            }


        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'restaurant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/braixses/aklooo.com/core/resources/views/templates/basic/restaurant/food/publish.blade.php ENDPATH**/ ?>