<?php

use Illuminate\Support\Facades\Route;


Route::namespace('Restaurant\Auth')->name('restaurant.')->middleware('guest')->group(function () {

    Route::controller('LoginController')->group(function () {
        Route::get('/login', 'showLoginForm')->name('login');
        Route::post('/login', 'login');
        Route::get('logout', 'logout')->withoutMiddleware('guest')->name('logout');
    });

    Route::controller('RegisterController')->group(function () {
        Route::get('register', 'showRegistrationForm')->name('register');
        Route::post('register', 'register');
        Route::post('check-user', 'checkUser')->name('checkUser')->withoutMiddleware('guest');
    });

    Route::controller('ForgotPasswordController')->prefix('password')->name('password.')->group(function () {
        Route::get('reset', 'showLinkRequestForm')->name('request');
        Route::post('email', 'sendResetCodeEmail')->name('email');
        Route::get('code-verify', 'codeVerify')->name('code.verify');
        Route::post('verify-code', 'verifyCode')->name('verify.code');
    });
    Route::controller('ResetPasswordController')->group(function () {
        Route::post('password/reset', 'reset')->name('password.update');
        Route::get('password/reset/{token}', 'showResetForm')->name('password.reset');
    });

    Route::controller('SocialiteController')->group(function () {
        Route::get('social-login/{provider}', 'socialLogin')->name('social.login');
        Route::get('social-login/callback/{provider}', 'callback')->name('social.login.callback');
    });
});


Route::middleware('restaurant')->name('restaurant.')->group(function () {
    Route::get('restaurant-data', 'Restaurant\RestaurantController@restaurantData')->name('data');
    Route::post('restaurant-data-submit', 'Restaurant\RestaurantController@restaurantDataSubmit')->name('data.submit');

    //authorization
    Route::middleware('restaurant.registration.complete')->namespace('Restaurant')->controller('AuthorizationController')->group(function () {
        Route::get('authorization', 'authorizeForm')->name('authorization');
        Route::get('resend-verify/{type}', 'sendVerifyCode')->name('send.verify.code');
        Route::post('verify-email', 'emailVerification')->name('verify.email');
        Route::post('verify-mobile', 'mobileVerification')->name('verify.mobile');
        Route::post('verify-g2fa', 'g2faVerification')->name('2fa.verify');
    });

    Route::middleware(['restaurant.check', 'restaurant.registration.complete'])->group(function () {
        Route::namespace('Restaurant')->group(function () {
            Route::controller('RestaurantController')->group(function () {
                Route::get('dashboard', 'home')->name('home');
                Route::get('download-attachments/{file_hash}', 'downloadAttachment')->name('download.attachment');

                //2FA
                Route::get('twofactor', 'show2faForm')->name('twofactor');
                Route::post('twofactor/enable', 'create2fa')->name('twofactor.enable');
                Route::post('twofactor/disable', 'disable2fa')->name('twofactor.disable');

                //KYC
                Route::get('kyc-form', 'kycForm')->name('kyc.form');
                Route::get('kyc-data', 'kycData')->name('kyc.data');
                Route::post('kyc-submit', 'kycSubmit')->name('kyc.submit');

                //Report
                Route::any('deposit/history', 'depositHistory')->name('deposit.history');
                Route::get('transactions', 'transactions')->name('transactions');
                Route::post('add-device-token', 'addDeviceToken')->name('add.device.token');

                //Reviews
                Route::get('reviews', 'reviews')->name('reviews');
            });


            //Profile setting
            Route::controller('ProfileController')->group(function () {
                Route::get('profile-setting', 'profile')->name('profile.setting');
                Route::post('profile-setting', 'submitProfile');
                Route::get('change-password', 'changePassword')->name('change.password');
                Route::post('change-password', 'submitPassword');
            });

            //Category
            Route::controller('CategoryController')->group(function () {
                Route::get('categories', 'categories')->name('categories');
                Route::post('categories/store/{id?}', 'storeCategories')->name('category.store');
                Route::post('categories/status/{id}', 'categoryStatus')->name('category.status');
            });

            //Manage Foods
            Route::controller('FoodController')->prefix('food')->name('food.')->group(function () {
                Route::get('/', 'index')->name('index');
                Route::get('/status/{id}', 'status')->name('status');


                Route::get('overview/{id?}', 'overview')->name('overview');
                Route::post('store-overview/{id?}', 'storeOverview')->name('store.overview');

                Route::get('image/{id?}', 'image')->name('image');
                Route::post('store-image/{id?}', 'storeImage')->name('store.image');

                Route::get('variation/{id?}', 'variation')->name('variation');
                Route::post('store-variation/{id?}', 'storeVariation')->name('store.variation');

                Route::get('addons/{id?}', 'addons')->name('addons');
                Route::post('store-addons/{id?}', 'storeAddons')->name('store.addons');

                Route::get('publish/{id?}', 'publish')->name('publish');
                Route::post('store-publish/{id?}', 'storePublish')->name('store.publish');

                Route::post('status/{id}', 'status')->name('status');
            });

            //Manage Orders
            Route::controller('OrderController')->prefix('order')->name('order.')->group(function () {
                Route::get('/', 'index')->name('index');
                Route::get('/active', 'active')->name('active');
                Route::get('/processing', 'processing')->name('processing');
                Route::get('/on-delivery', 'onDelivery')->name('on.delivery');
                Route::get('/delivered', 'delivered')->name('delivered');
                Route::get('/completed', 'completed')->name('completed');
                Route::get('/cancelled', 'cancelled')->name('cancelled');
                Route::get('/details/{id}', 'details')->name('details');

                Route::post('cancel-order/{id}', 'cancelOrder')->name('cancel');
                Route::post('on-delivery/{id}', 'onDeliveryOrder')->name('on.delivery.submit');
                Route::post('deliver-order/{id}', 'deliverOrder')->name('deliver');
                Route::get('/ship-order/{id}', 'shipOrder')->name('ship');

                Route::get('delivery-setting', 'delivery')->name('delivery.setting');
                Route::post('delivery-setting', 'storeDeliverySettings');
            });

            Route::controller('OrderController')->group(function () {
                Route::get('delivery-setting', 'delivery')->name('delivery.setting');
                Route::post('delivery-setting/store', 'storeDeliverySettings')->name('delivery.setting.store');
            });

            //Manage Plans
            Route::controller('PlanController')->prefix('plan')->name('plan.')->group(function () {
                Route::get('/', 'index')->name('index');
                Route::post('/purchase/{id}', 'purchase')->name('purchase');
            });


            // Withdraw
            Route::controller('WithdrawController')->prefix('withdraw')->name('withdraw')->group(function () {
                Route::middleware('kyc')->group(function () {
                    Route::get('/', 'withdrawMoney');
                    Route::post('/', 'withdrawStore')->name('.money');
                    Route::get('preview', 'withdrawPreview')->name('.preview');
                    Route::post('preview', 'withdrawSubmit')->name('.submit');
                });
                Route::get('history', 'withdrawLog')->name('.history');
                Route::get('approved', 'withdrawApproved')->name('.approved');
                Route::get('pending', 'withdrawPending')->name('.pending');
            });

            Route::controller('TicketController')->prefix('ticket')->group(function () {
                Route::get('all', 'supportTicket')->name('ticket.index');
                Route::get('new', 'openSupportTicket')->name('ticket.open');
                Route::post('create', 'storeSupportTicket')->name('ticket.store');
                Route::get('view/{ticket}', 'viewTicket')->name('ticket.view');
                Route::post('reply/{ticket}', 'replyTicket')->name('ticket.reply');
                Route::post('close/{ticket}', 'closeTicket')->name('ticket.close');
                Route::get('download/{ticket}', 'ticketDownload')->name('ticket.download');
            });
        });

        // Payment
        Route::prefix('deposit')->name('deposit.')->controller('Gateway\PaymentController')->group(function () {
            Route::get('confirm', 'depositConfirm')->name('confirm');
            Route::get('manual', 'manualDepositConfirm')->name('manual.confirm');
            Route::post('manual', 'manualDepositUpdate')->name('manual.update');
            Route::post('insert/{orderId?}', 'depositInsert')->name('insert');
            Route::any('/{orderId?}', 'deposit')->name('index');
        });
    });
});

