@extends($activeTemplate . 'layouts.' . $layout)
@section('content')
    @if (!auth()->user())
        <div class="py-70">
            <div class="container">
                <div class="card custom--card">
                    <div class="card-body ps-4 pe-4">
    @endif
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card-header-bg">
                    <h6 class="my-0 support-form-title">
                        @php echo $myTicket->statusBadge; @endphp
                        [@lang('Ticket')#{{ $myTicket->ticket }}] {{ $myTicket->subject }}
                    </h6>
                    @if ($myTicket->status != Status::TICKET_CLOSE && $myTicket->user)
                        <button class="confirmationBtn ticket-close-btn" type="button" data-question="@lang('Are you sure to close this ticket?')"
                            data-action="{{ route('ticket.close', $myTicket->id) }}">
                            <i class="la la-times"></i>
                        </button>
                    @endif
                </div>
                <div class="card-body">
                    <form method="post" class="disableSubmission" action="{{ route('ticket.reply', $myTicket->id) }}"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="row justify-content-between">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <textarea name="message" class="form-control form--control" rows="4" required>{{ old('message') }}</textarea>
                                </div>
                            </div>

                            <div class="col-md-9">
                                <button type="button" class="btn btn-dark btn-sm addAttachment my-2"> <i
                                        class="fas fa-plus"></i> @lang('Add Attachment') </button>
                                <p class="mb-2"><span class="text--info">@lang('Max 5 files can be uploaded | Maximum upload size is ' . convertToReadableSize(ini_get('upload_max_filesize')) . ' | Allowed File Extensions: .jpg, .jpeg, .png, .pdf, .doc, .docx')</span></p>
                                <div class="row fileUploadsContainer">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn--base w-100 my-2" type="submit"><i
                                        class="la la-fw la-lg la-reply"></i> @lang('Reply')
                                </button>
                            </div>

                        </div>
                    </form>
                </div>

                <div class="support-ticket-list mt-4">
                    @forelse($messages as $message)
                        @if ($message->admin_id == 0)
                            <div class="support-ticket mb-4">
                                <div class="flex-align gap-3 mb-2">
                                    <h6 class="support-ticket-name">{{ $message->ticket->name }}</h6>
                                    <p class="support-ticket-date">
                                        @lang('Posted on') {{ showDateTime($message->created_at, 'l, dS F Y @ h:i a') }}
                                    </p>
                                </div>
                                <p class="support-ticket-message">{{ $message->message }}</p>
                                @if ($message->attachments->count() > 0)
                                    <div class="support-ticket-file mt-2">
                                        @foreach ($message->attachments as $k => $image)
                                            <a class="text--base" href="{{ route('ticket.download', encrypt($image->id)) }}"
                                                class="me-3">
                                                <span class="icon"><i class="la la-file-download"></i></span>
                                                @lang('Attachment') {{ ++$k }}
                                            </a>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                        @else
                            <div class="support-ticket mb-4">
                                <div class="flex-align gap-3 mb-2">
                                    <h6 class="support-ticket-name">{{ $message->admin->name }}</h6>
                                    <p class="support-ticket-date">
                                        @lang('Posted on') {{ showDateTime($message->created_at, 'l, dS F Y @ h:i a') }}
                                    </p>
                                </div>
                                <p class="support-ticket-message">{{ $message->message }}</p>
                                @if ($message->attachments->count() > 0)
                                    <div class="support-ticket-file mt-2">
                                        @foreach ($message->attachments as $k => $image)
                                            <a class="text--base"
                                                href="{{ route('ticket.download', encrypt($image->id)) }}" class="me-3">
                                                <span class="icon"><i class="la la-file-download"></i></span>
                                                @lang('Attachment') {{ ++$k }}
                                            </a>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                        @endif
                    @empty
                        <div class="empty-message text-center">
                            <img src="{{ asset('assets/images/empty_list.png') }}" alt="empty">
                            <h5 class="text-muted">@lang('No replies found here!')</h5>
                        </div>
                    @endforelse
                </div>

            </div>
        </div>
    </div>
    @if (!auth()->user())
        </div>
        </div>
        </div>
        </div>
    @endif

    <x-confirmation-modal />
@endsection
@push('style')
    <style>
        .input-group-text:focus {
            box-shadow: none !important;
        }

        .reply-bg {
            background-color: #ffd96729
        }

        .empty-message img {
            width: 120px;
            margin-bottom: 15px;
        }
    </style>
@endpush
@push('script')
    <script>
        (function($) {
            "use strict";
            var fileAdded = 0;
            $('.addAttachment').on('click', function() {
                fileAdded++;
                if (fileAdded == 5) {
                    $(this).attr('disabled', true)
                }
                $(".fileUploadsContainer").append(`
                    <div class="col-lg-4 col-md-12 removeFileInput">
                        <div class="form-group">
                            <div class="input-group">
                                <input type="file" name="attachments[]" class="form-control" accept=".jpeg,.jpg,.png,.pdf,.doc,.docx" required>
                                <button type="button" class="input-group-text removeFile bg--danger border--danger"><i class="fas fa-times"></i></button>
                            </div>
                        </div>
                    </div>
                `)
            });
            $(document).on('click', '.removeFile', function() {
                $('.addAttachment').removeAttr('disabled', true)
                fileAdded--;
                $(this).closest('.removeFileInput').remove();
            });
        })(jQuery);
    </script>
@endpush
