@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="dashboard-table">
        <div class="dashbaord-table-header">
            <h6 class="card-header__title mb-0">@lang('Orders') <i class="las la-shopping-cart text--base"></i></h6>
            <form class="search-form active">
                <input type="text" name="search" class="form--control" value="{{ request()->search }}"
                    placeholder="@lang('Search by restaurant name')">
                <button type="submit" class="search-form__btn"><i class="las la-search"></i></button>
            </form>
        </div>


        <table class="table table--responsive--xl">
            <thead>
                <tr>
                    <th>@lang('Restaurant name')</th>
                    <th class="text-center">@lang('Price')</th>
                    <th class="text-center">@lang('Payment')</th>
                    <th class="text-center">@lang('Payment Type')</th>
                    <th class="text-center">@lang('Status')</th>
                    <th>@lang('Action')</th>
                </tr>
            </thead>
            <tbody>

                @forelse($orders as $order)
                    <tr>
                        <td lass="text-left">
                            <span class="fw-bold">
                                <a href="{{ route('restaurant.details', @$order->restaurant->slug) }}" class="text--base">
                                    {{ __(@$order->restaurant->restaurant_name) }}
                                </a>
                            </span>
                        </td>
                        <td class="text-center">
                            {{ showAmount($order->total_price) }}
                        </td>
                        <td class="text-center">
                            @php echo $order->paymentData @endphp
                        </td>

                        <td>
                            @php echo $order->typeBadge @endphp
                        </td>

                        <td class="text-center">
                            @php echo $order->statusBadge @endphp
                        </td>
                        <td>
                            <a class="btn btn--sm btn--base detailBtn" href="{{ route('user.order.details', $order->id) }}">
                                <i class="la la-desktop"></i>
                            </a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    {{ paginateLinks($orders) }}
@endsection
