@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $orderTotalPrice = 0;
        $vat = $cartItems->first()->restaurant->vat;
        $deliveryFee = $cartItems->first()->restaurant->delivery_charge;
        $restaurant = $cartItems->first()->restaurant;
    @endphp

    <div class="common-body section-bg-two pt-80 pb-80">
        <div class="container">
            <div class="row gy-4">
                <div class="col-xl-8 col-lg-8">
                    <form action="{{ route('user.order.submit') }}" method="POST">
                        @csrf
                        @include($activeTemplate . 'partials.addresses')
                        <div class="additinal-note">
                            <h4>@lang('Additinal Note')</h4>
                            <div class="col-12">
                                <div class="input-group">
                                    <input type="text" id="additional_notes" class="form-control form--control"
                                        name="additional_notes" placeholder="none">
                                    <label for="additional_notes">@lang('Additinal Note')</label>
                                </div>
                            </div>
                        </div>
                        <div class="payment">
                            <h4>@lang('Payment')</h4>
                            <div class="bank-card">
                                <div class="row gy-4">
 

                                    <div class="col-xl-6">
                                        <div class="custom--radio bank-card-box">
                                            <input type="radio" value="1" id="cash" class="form-check-input"
                                                name="payment_type">
                                            <label for="cash">
                                                <i class="fas fa-money-bill-alt"></i>
                                                @lang('Cash On Delivery')
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn  btn--base w-100 btn--md">@lang('Place Order')</button>
                        </div>
                    </form>
                </div>
                <div class="col-xl-4 col-lg-4">
                    <div class="checkout-summary">
                        <p>@lang('Your Order Form') <a
                                href="{{ route('restaurant.details', $restaurant->slug) }}">{{ __($restaurant->restaurant_name) }}</a>
                        </p>
                        <span class="pb-10">-{{ __($restaurant->location->name) }} </span>

                        <ul class="checkout-summary-item">
                            @foreach ($cartItems as $item)
                                @php
                                    $itemPrice = 0;
                                    $itemPrice = $itemPrice + $item->food->price;
                                    foreach ($item->variations ?? [] as $variationItemId) {
                                        $variationItem = App\Models\VariantItem::find($variationItemId);
                                        $itemPrice = $itemPrice + $variationItem->price;
                                    }
                                    foreach ($item->addons ?? [] as $addonsId) {
                                        $addonItem = App\Models\Addon::find($addonsId);
                                        $itemPrice = $itemPrice + $addonItem->price;
                                    }
                                    $itemPrice = $itemPrice * $item->quantity;
                                    $orderTotalPrice = $orderTotalPrice + $itemPrice;
                                @endphp
                                <li><span>{{ __($item->food->name) }}</span>
                                    <span>{{ showAmount($itemPrice) }}</span>
                                </li>
                            @endforeach
                        </ul>

                        <ul class="checkout-summary-total">
                            <li><span>@lang('Subtotal')</span>
                                <span>{{ showAmount($orderTotalPrice) }}</span>
                            </li>
                            <li><span>@lang('Delivery Fee')</span>
                                <span>{{ showAmount($deliveryFee) }}</span>
                            </li>
                            <li><span>@lang('Vat')</span>
                                <span>{{ showAmount($orderTotalPrice * ($vat / 100)) }}</span>
                            </li>
                        </ul>
                        <ul class="total-payment">
                            <li class=""><span>@lang('Total')(@lang('Incl').@lang('VAT'))</span>
                                <span>{{ showAmount($orderTotalPrice + $deliveryFee + $orderTotalPrice * ($vat / 100)) }}</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="addressModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="delivery-address-modal">
                            <div class="delivery-form">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" name="street" class="form-control form--control"
                                                    placeholder="none">
                                                <label for="name">@lang('Street number')</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" name="apartment" class="form-control form--control"
                                                    placeholder="none">
                                                <label for="Apartment">@lang('Apartment')</label>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="type">
                                </div>
                                <div class="delivcery-label">
                                    <h6>@lang('Select A Label')</h6>
                                    <ul class="delivery-process">
                                        <li> <a href="javascript:void(0)" data-type="{{ Status::USER_ADDRESS_HOME }}"><i
                                                    class="las la-home"></i></a>
                                            <div class="delivery">@lang('Home')</div>
                                        </li>
                                        <li> <a href="javascript:void(0)" data-type="{{ Status::USER_ADDRESS_WORK }}"><i
                                                    class="las la-briefcase"></i></a>
                                            <div class="delivery">@lang('Work')</div>
                                        </li>
                                        <li> <a href="javascript:void(0)" data-type="{{ Status::USER_ADDRESS_OTHER }}"><i
                                                    class="las la-map-marker"></i></a>
                                            <div class="delivery">@lang('Others')</div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <x-confirmation-modal />
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";
            $(document).on('click', '.editAddressBtn', function() {
                var modal = $('#addressModal');
                var data = $(this).data('info');
                modal.find('.modal-title').text('Edit Modal');
                modal.find('form')[0].reset();
                modal.find('form').attr('action', $(this).data('url'));

                modal.find('input[name="street"]').val(data.street);
                modal.find('input[name="apartment"]').val(data.apartment);
                modal.find('input[name="type"]').val(data.type);

                $('.delivery-process li a').removeClass('active');
                $('.delivery-process li a[data-type="' + data.type + '"]').addClass('active');

                modal.modal('show');
            });

            $(document).on('click', '.addAddressBtn', function() {
                var modal = $('#addressModal');
                modal.find('.modal-title').text('Add Modal');
                modal.find('form')[0].reset();
                modal.find('form').attr('action', $(this).data('url'));
                modal.modal('show');
            });

            $(document).on('click', '.view-address button', function() {
                $('.delivery-address-box').removeClass('d-none');
                $('.edit-tag .select-address').removeClass('d-none');
                $('input[name="address_id"]').val(null);
                $('.view-address button').remove();
                notify('warning', 'Please select an address');
            });

            $(document).ready(function() {
                $('.delivery-process li a').on('click', function() {
                    $('.delivery-process li a').removeClass('active');
                    $(this).addClass('active');

                    var dataType = $(this).data('type');
                    $('input[name="type"]').val(dataType);
                });
            });

        })(jQuery);
    </script>
@endpush
