@extends($activeTemplate . 'layouts.frontend')

@section('content')
    <div class="container py-70">
        <div class="d-flex justify-content-center">
            <div class="verification-code-wrapper">
                <div class="verification-area">
                    <form action="{{ route('user.verify.mobile') }}" method="POST" class="submit-form">
                        @csrf

                        <div class="alert alert-info mb-3">
                            شكراً لتسجيلك معنا. سوف نتواصل معك قريباً لتأكيد بياناتك وتفعيل حسابك.
                        </div>

                        <a href="https://aklooo.com/" class="text--base">تصفح المطاعم </a>

                        @if ($errors->any())
                            <br />
                            <small class="text--danger">{{ $errors->first() }}</small>
                        @endif
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        var distance = Number("{{ @$user->ver_code_send_at->addMinutes(2)->timestamp - time() }}");
        var x = setInterval(function() {
            distance--;
            document.getElementById("countdown").innerHTML = distance;
            if (distance <= 0) {
                clearInterval(x);
                document.querySelector('.countdown-wrapper').classList.add('d-none');
                document.querySelector('.try-again-link').classList.remove('d-none');
            }
        }, 1000);
    </script>
@endpush
