@php
    $popularRestaurant = getContent('popular_restaurant.content', true);
    $restaurants = App\Models\Restaurant::active()
        ->whereHas('foods')
        ->with('location', 'reviews')
        ->featured()
        ->with('location');
    $restaurants = sortRestaurants($restaurants);
    $showAllBtn = $restaurants->count() > 8;
    $restaurants = $restaurants->take(8);
@endphp

<section class="nearby-restaurant-area section-bg-two pt-40 pb-80">
    <img class="nearby-restaurant-shape-2" src="{{ getImage($activeTemplateTrue . 'images/food-shape-2.png') }}"
        alt="img not found">
    <img class="nearby-restaurant-shape-dark" src="{{ getImage($activeTemplateTrue . 'images/food-shape-dark.png') }}"
        alt="img not found">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="section-common pb-20 d-flex align-items-center justify-content-between">
                    <h4 class="section-title">
                        {{ __(@$popularRestaurant->data_values->heading) }}
                    </h4>
                    @if ($showAllBtn)
                        <a href="{{ route('popular.restaurants') }}" class="btn btn--base btn--sm"> @lang('View All') <span
                                class="section-icon"><i class="la la-arrow-right"></i></span> </a>
                    @endif
                </div>
            </div>
        </div>
        <div class="nearby-restaurant">
            <div class="row gy-4">
                @foreach ($restaurants as $restaurant)
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col--xm-6">
                        <x-restaurant :restaurant="$restaurant" />
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
