@php
    $contactSectionContent = getContent('contact_section.content', true);
    $contact = getContent('contact_us.content', true);
@endphp



<div class="contact-meta section-bg-two pb-120">
    <img class="contact-image"
        src="{{ frontendImage('contact_section', @$contactSectionContent->data_values->light_image, '675x350') }}"
        alt="img not found" />
    <img class="contact-image-dark"
        src="{{ frontendImage('contact_section', @$contactSectionContent->data_values->dark_image, '675x350') }}"
        alt="img not found" />
    <div class="container">
        <div class="row gy-4">
            <div class="col-lg-6 col-md-6">
                <div class="download-app__left">
                    <h2 class="download-app__left-title">
                        {{ __(@$contactSectionContent->data_values->title) }}
                    </h2>
                    <p class="download-app__left-subtitle">
                        @php echo @$contactSectionContent->data_values->description @endphp
                    </p>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="contact-info-wrapper">
                    <div class="contact-info">
                        <div class="contact-info-item">
                            <div class="icon">
                                <i class="fas fa-map-marker-alt"></i>
                            </div>
                            <div class="content">
                                <h6 class="title">@lang('Office Address')</h6>
                                <p>
                                    {{ __(@$contact->data_values->address) }}
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="contact-info">
                        <div class="contact-info-item">
                            <div class="icon">
                                <i class="lab la-telegram-plane"></i>
                            </div>
                            <div class="content">
                                <h6 class="title">@lang('Email Address')</h6>
                                <p>
                                    <a
                                        href="mailto:{{ @$contact->data_values->email_address }}">{{ @$contact->data_values->email_address }}</a>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="contact-info">
                        <div class="contact-info-item">
                            <div class="icon icon-phone-animation">
                                <i class="las la-phone-volume"></i>
                            </div>
                            <div class="content">
                                <h6 class="title">@lang('Phone Number')</h6>
                                <p>
                                    <a
                                        href="tel:{{ @$contact->data_values->contact_number }}">{{ @$contact->data_values->contact_number }}</a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
