@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $advertisement_banner = showAd('1296x190');
        $advertisement_category_nav = showAd('305x380');
        $request = request();
    @endphp

    <section class="common-body section-bg-two pt-80 pb-80">
        <div class="container">

            @if ($advertisement_banner)
                <a class="ad-thumb"
                    @if ($advertisement_banner['route']) href="{{ $advertisement_banner['route'] }}"  target="_blank" @endif>
                    <img src="{{ $advertisement_banner['image'] }}" alt="ad-thumb">
                </a>
            @endif

            <form action="{{ route('search') }}" method="get" id="sortForm">
                <input type="hidden" name="type" value="{{ $request->type }}">
                <input type="hidden" name="category" value="{{ request()->category }}">
                <input type="hidden" name="location" value="{{ $request->location }}">
                <input type="hidden" name="sort" value="{{ $request->sort }}">
                <input type="hidden" name="search" value="{{ $request->search }}">
                <input type="hidden" name="page" value="{{ $request->page }}">
            </form>
            <div class="row gy-4">
                <div class="col-xl-3">
                    <div class="grid-sidebar">
                        <div class="filter-sidebar__header d-flex align-items-center justify-content-between gap-2">
                            <h6 class="title">
                                @lang('Filter') </h6>
                            <div class="right">
                                <button class="side-sidebar-close-btn d-block d-xl-none" type="button"><i
                                        class="las la-times"></i></button>
                            </div>
                        </div>
                        <form action="{{ route('search') }}" class="search-form search-box-wrapper mb-4">
                            <div class="search-box">
                                <input type="text" class="form--control" name="search"
                                    placeholder="@lang('Search any keyword')..." value="{{ $request->search }}" id="search">
                                <button type="submit" class="search-box__button"><i class="las la-search"></i></button>
                            </div>
                        </form>

                        <h6 class="grid-sidebar__title">@lang('Type')</h6>
                        <div class="category">
                            <div class="form-group">
                                <div class="form-check form--radio">
                                    <input class="form-check-input type-radio" type="radio" name="type" id="restaurant"
                                        value="restaurant" @checked($type == 'restaurant')>
                                    <label class="form-check-label" for="restaurant">
                                        @lang('Restaurants')
                                    </label>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="form-check form--radio">
                                    <input class="form-check-input type-radio" type="radio" name="type" id="food"
                                        value="food" @checked($type == 'food')>
                                    <label class="form-check-label" for="food">
                                        @lang('Foods')
                                    </label>
                                </div>
                            </div>
                        </div>
                        <h6 class="grid-sidebar__title">@lang('Category')</h6>
                        <div class="category">
                            <div class="form-group">
                                <div class="form-check form--radio">
                                    <input class="form-check-input category-radio" type="radio" name="category"
                                        id="all-category" value="" checked="">
                                    <label class="form-check-label" for="all-category">
                                        @lang('All') </label>
                                </div>
                            </div>
                            @foreach ($categories as $category)
                                <div class="form-group">
                                    <div class="form-check form--radio">
                                        <input class="form-check-input category-radio" type="radio" name="category"
                                            id="{{ $category->slug }}" value="{{ $category->slug }}"
                                            @checked($category->slug == $request->category)>
                                        <label class="form-check-label" for="{{ $category->slug }}">
                                            {{ __($category->name) }}
                                        </label>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        @if ($advertisement_category_nav)
                            <a class="sidebar-thumb"
                                @if ($advertisement_category_nav['route']) href="{{ $advertisement_category_nav['route'] }}" target="_blank" @endif>
                                <img src="{{ $advertisement_category_nav['image'] }}" alt="ad-thumb">
                            </a>
                        @endif
                    </div>


                </div>
                <div class="col-xl-9">
                    <span class="event-filter d-xl-none d-block">
                        <button class="event-filter__button">
                            <i class="las la-filter"></i>
                            <span class="text"> @lang('Filter') </span>
                        </button>
                    </span>
                    <div class="grid-event-header">
                        <span class="grid-event-header__title">
                            @lang('Result'): {{ $resultCount }} @lang('items Found') </span>
                        <div class="flex-between grid-event-header-content ms-auto gap-2">
                            <div class="grid-event-form-inner">
                                <form action="#">
                                    <select class="select2-basic location-select">
                                        <option value="">@lang('All Locations')</option>
                                        @foreach ($locations as $location)
                                            <option value="{{ $location->slug }}" @selected($location->slug == $request->location)>
                                                {{ __($location->name) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </form>
                            </div>
                            <div class="grid-event-form-inner">
                                <form action="#">
                                    <select class="select2-basic sort-select" aria-label="sort select">
                                        <option value="">@lang('Sort By')
                                        <option value="newestToOldest" @selected($request->sort == 'newestToOldest')>@lang('Newest to oldest')
                                        </option>
                                        <option value="oldestToNewest" @selected($request->sort == 'oldestToNewest')>@lang('Oldest to newest')
                                        </option>
                                        @if ($type == 'food')
                                            <option value="priceLowToHigh" @selected($request->sort == 'priceLowToHigh')>
                                                @lang('Price')(@lang('Low') -
                                                @lang('High'))
                                            </option>
                                            <option value="priceHighToLow" @selected($request->sort == 'priceHighToLow')>
                                                @lang('Price')(@lang('High') -
                                                @lang('Low'))</option>
                                        @endif
                                        @if ($type == 'restaurant')
                                            <option value="ratingLowToHigh" @selected($request->sort == 'ratingLowToHigh')>
                                                @lang('Rating')(@lang('Low') -
                                                @lang('High'))
                                            </option>
                                            <option value="ratingHighToLow" @selected($request->sort == 'ratingHighToLow')>
                                                @lang('Rating')(@lang('High') -
                                                @lang('Low'))</option>
                                        @endif
                                        <option value="location" @selected($request->sort == 'location')>@lang('Location')</option>
                                        <option value="restaurant" @selected($request->sort == 'restaurant')>@lang('Restaurants')
                                        </option>
                                    </select>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="row gy-4">
                        @forelse ($data ?? [] as $item)
                            @if ($type == 'restaurant')
                                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col--xm-6">
                                    <x-restaurant :restaurant="$item" />
                                </div>
                            @elseif($type == 'food')
                                <div class="col-md-6 col-sm-6 col--xm-6">
                                    <x-food :food="$item" :isSection="true" />
                                </div>
                            @endif
                        @empty
                            <div class="text-center">{{ __($emptyMessage) }}</div>
                        @endforelse
                    </div>
                    <div class="mt-3">
                        {{ paginateLinks($data) }}
                    </div>

                </div>
            </div>

        </div>
    </section>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";
            $(document).ready(function() {
                $('.type-radio').on('change', function() {
                    $('#sortForm').find('input[name="type"]').val(this.value);
                    $('#sortForm').find('input[name="page"]').val(null)
                    $('#sortForm').submit();
                });


                $('.category-radio').on('change', function() {
                    $('#sortForm').find('input[name="category"]').val(this.value);
                    $('#sortForm').find('input[name="page"]').val(null)
                    $('#sortForm').submit();
                });

                $('.location-select').on('change', function() {
                    $('#sortForm').find('input[name="location"]').val(this.value);
                    $('#sortForm').find('input[name="page"]').val(null)
                    $('#sortForm').submit();
                });

                $('.sort-select').on('change', function() {
                    $('#sortForm').find('input[name="sort"]').val(this.value);
                    $('#sortForm').find('input[name="page"]').val(null)
                    $('#sortForm').submit();
                });

                $('.search-form').on('submit', function(e) {
                    e.preventDefault();
                    var value = $(this).find('input[name="search"]').val();
                    $('#sortForm').find('input[name="search"]').val(value);
                    $('#sortForm').find('input[name="page"]').val(null)
                    $('#sortForm').submit();
                });

                $('.pagination a').each(function() {
                    $(this).removeAttr('href').attr('href', 'javascript:void(0)');
                });

                $('.pagination a').on('click', function() {
                    var page = this.innerText;
                    var currentActivePage = parseInt($('.page-item.active .page-link').text());
                    if (page == '‹') {
                        page = parseInt(currentActivePage - 1);
                    }
                    if (page == '›') {
                        page = parseInt(currentActivePage + 1);
                    }
                    $('#sortForm').find('input[name="page"]').val(page);
                    $('#sortForm').submit();
                });
            });
        })(jQuery);
    </script>
@endpush
