@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $advertisement_banner_one = showAd('1296x190');
        $advertisement_banner_two = showAd('1296x190');
    @endphp
    <div class="cart-page-inner">
        <div class="cart-page">
            <div class="restaurast-banner bg-img"
                style="background-image: url({{ getImage(getFilePath('restaurantCover') . '/' . $restaurant->cover_image, getFileSize('restaurantCover'), cover: true) }})">

                <h1 class="restaurast-banner-title">{{ __($restaurant->restaurant_name) }}</h1>

            </div>
            <section class="restaurant-info pt-40 pb-40">
                <div class="container">
                    <div class="row gy-4 align-items-center">
                        <div class="col-xl-8 col-lg-8 col-md-7 col-sm-7">
                            <div class="restaurant-info-box d-flex">
                                <div class="restaurant-info-box__thumb">
                                    <img src="{{ getImage(getFilePath('restaurantProfile') . '/' . $restaurant->profile_image, getFileThumbSize('restaurantProfile'), avatar: true) }}"
                                        alt="img not found">
                                </div>
                                <div class="restaurant-info-box__meta">
                                    <h4 class="restaurant-info-box__meta-title">
                                        {{ __($restaurant->restaurant_name) }}
                                    </h4>
                                    <span class="restaurant-info-box__meta-location"><i
                                            class="fas fa-map-marker-alt"></i>{{ __($restaurant->location->name) }}</span>
                                    <ul class="restaurant-info-box__meta-rating">
                                        <li>
                                            @php echo $restaurant->reviewStars @endphp
                                        </li>

                                        @php
    $status = $restaurant->provider;
    $badgeClass = 'badge'; // أساس
    $customStyle = '';

    if ($status == 'مغلق') {
        $customStyle = 'background-color: #dc3545; color: white;'; // أحمر مع نص أسود
    } elseif ($status == 'مشغول') {
        $customStyle = 'background-color: #fff700; color: black;'; // أصفر فاقع مع نص أسود
    } elseif ($status == 'مفتوح') {
        $customStyle = 'background-color: #007bff; color: white;'; // أزرق لبني مع نص أسود
    }
@endphp

<li>
    <span class="badge badge--sm" style="{{ $customStyle }}">
        {{ __($status) }}
    </span>
</li>

                                        <li class="fav-icon {{ restaurantIsFavorite($restaurant) }}"
                                            data-url={{ route('restaurant.favorite', $restaurant->id) }}><i
                                                class="far fa-heart"></i></li>
                                    </ul>
                                    <ul class="restaurant-info-box__meta-time">
                                        <li><i class="las la-clock"></i>{{ $restaurant->delivery_time }} @lang('Mins')
                                        </li>
                                        <li><i class="las la-biking"></i>{{ showAmount($restaurant->delivery_charge) }}
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-5 col-sm-5">
                            <div class="restaurant-btn text-sm-end">
                                @auth
                                    <a href="#" class="btn btn--base btn--lg" data-bs-toggle="modal"
                                        data-bs-target="#reviewModal">@lang('Write a Review')</a>
                                @else
                                    <a href="{{ route('user.login') }}" class="btn btn--base btn--lg">@lang('Write a Review')</a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <section class="common-body section-bg-two pt-50 pb-80">
                    <div class="foods-navbar-area">
                        @if ($advertisement_banner_one)
                            <div class="container">
                                <a class="ad-thumb"
                                    @if ($advertisement_banner_one['route']) href="{{ $advertisement_banner_one['route'] }}" target="_blank" @endif>
                                    <img src="{{ $advertisement_banner_one['image'] }}" alt="ad-thumb">
                                </a>
                            </div>
                        @endif
                        {{-- navs --}}
                        <div class="container" id="carts">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="foods-navbar pb-50">
                                        <nav class="foods-navbar__nav ">
                                            <div class="nav nav-tabs tabs__widets-default-menu-link" id="nav-tab"
                                                role="tablist">
                                                <button class="nav-link active" id="all-tab" data-bs-toggle="tab"
                                                    data-bs-target="#all" type="button" role="tab" aria-controls="all"
                                                    aria-selected="true">@lang('All')</button>
                                                @foreach ($categories as $category)
                                                    <button class="nav-link" id="{{ 'category_' . $category->id }}-tab"
                                                        data-bs-toggle="tab"
                                                        data-bs-target="#{{ 'category_' . $category->id }}" type="button"
                                                        role="tab" aria-controls="{{ 'category_' . $category->id }}"
                                                        aria-selected="false">{{ __($category->name) }}</button>
                                                @endforeach
                                            </div>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- tabs start --}}
                        <div class="container pb-60">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="tab-content" id="nav-tabContent">
                                        <div class="tab-pane fade show active" id="all" role="tabpanel"
                                            aria-labelledby="all-tab">

                                            @foreach ($categories as $category)
                                                <div class="section-common pb-20">
                                                    <h4 class="section-title">{{ __($category->name) }}</h4>
                                                </div>
                                                <div class="popular-foods-wrapper pb-40">
                                                    <div class="row gy-4">
                                                        @foreach ($category->foods as $food)
                                                            <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col--xm-6">
                                                                <x-food :food="$food" />
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            @endforeach

                                        </div>
                                        @foreach ($categories as $category)
                                            <div class="tab-pane fade" id="{{ 'category_' . $category->id }}" role="tabpanel"
                                                aria-labelledby="{{ 'category_' . $category->id }}-tab">
                                                <div class="section-common pb-20">
                                                    <h4 class="section-title">{{ __($category->name) }}</h4>
                                                </div>
                                                <div class="popular-foods-wrapper pb-40">
                                                    <div class="row gy-4">
                                                        @foreach ($category->foods as $food)
                                                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col--xm-6">
                                                                <x-food :food="$food" />
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                        @if ($advertisement_banner_two)
                            <div class="container">
                                <a class="ad-thumb"
                                    @if ($advertisement_banner_two['route']) href="{{ $advertisement_banner_two['route'] }}" target="_blank" @endif>
                                    <img src="{{ $advertisement_banner_two['image'] }}" alt="ad-thumb">
                                </a>
                            </div>
                        @endif
                    </div>
                </section>
            </div>

        </div>

        {{-- food modal --}}
        <div class="modal add-card fade" id="foodcart" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form id="addFoodModal">
                        <input type="hidden" name="food_id">
                        <input type="hidden" name="restaurant_id">
                        <div class="add-card-box">
                            <div class="add-card__thumb">
                                <img class="w-100" id="food" src="" alt="img not found">
                                <button type="button" class="btn-close cross-btn" data-bs-dismiss="modal"
                                    aria-label="Close"><i class="las la-times"></i></button>
                            </div>
                            <div class="add-card__item">
                                <div class="add-card__item__top">
                                    <h4 class="title">
                                    </h4>

                                    <p class="desc">
                                    </p>
                                </div>
                                <div class="add-card-variation">
                                    <div class="common-title">
                                        <h4>@lang('Variation')</h4>
                                        <div class="variations">

                                        </div>
                                    </div>
                                </div>
                                <div class="add-card-frequently">
                                    <div class="common-title">
                                        <h4>@lang('Addons')</h4>
                                    </div>
                                    <ul>
                                    </ul>
                                </div>
                                <div class="add-card-note">
                                    <div class="common-title">
                                        <h4>@lang('Additional Note'):</h4>
                                        <span>@lang('Please let us know if you are allergic to anything or if we need to avoid anything').</span>
                                    </div>
                                    <form action="mail.php">
                                        <div class="input-group">
                                            <textarea class="form-control form--control" placeholder="@lang('Write Here')" id="message"
                                                name="additional_notes"></textarea>
                                            <label for="message" class="form-label textarea-input">@lang('Write Here')</label>
                                        </div>
                                        <div class="add-card-note-bottom  mt-30">
                                            <ul class="qnty-cart-list">
                                                <li class="qnty-cart-list__item">
                                                    <div class="product-qty">
                                                        <button type="button"
                                                            class="product-qty__btn modal__product-qty__decrement product-qty-border"><i
                                                                class="las la-minus"></i></button>
                                                        <input type="number"
                                                            class="product-qty__value product-qty__btn product-qty_trans modal__product-qty__value"
                                                            name="quantity" value="1">
                                                        <button type="button"
                                                            class="product-qty__btn modal__product-qty__increment product-qty-white"><i
                                                                class="las la-plus"></i></button>
                                                    </div>
                                                </li>
                                                <li class="qnty-cart-list__item">
                                                    <button class="btn btn-location btn--base btn--md"
                                                        id="addToCart">@lang('Add to Cart')</button>
                                                </li>
                                            </ul>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{-- review modal --}}
        @auth
            <div class="modal fade delivery-location" id="reviewModal" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <form action="{{ route('user.review.restaurant') }}" method="POST">
                            @csrf
                            <div class="delivery-location-inner">
                                <button type="button" class="btn-close cross-btn" data-bs-dismiss="modal" aria-label="Close">
                                    <i class="las la-times"></i>
                                </button>
                                <h4 class="delivery-location-title">@lang('Write a review')</h4>
                                <div class="rating_wrapper">
                                    <div class="rating-group">
                                        <input checked="" class="rating__input" name="rating" value=""
                                            type="radio">
                                        <label class="rating__label" for="rating-1"><i
                                                class="rating__icon rating__icon--star la la-star"></i></label>
                                        <input class="rating__input" name="rating" value="1" id="rating-1"
                                            type="radio">
                                        <label class="rating__label" for="rating-2"><i
                                                class="rating__icon rating__icon--star la la-star"></i></label>
                                        <input class="rating__input" name="rating" value="2" id="rating-2"
                                            type="radio">
                                        <label class="rating__label" for="rating-3"><i
                                                class="rating__icon rating__icon--star la la-star"></i></label>
                                        <input class="rating__input" name="rating" value="3" id="rating-3"
                                            type="radio">
                                        <label class="rating__label" for="rating-4"><i
                                                class="rating__icon rating__icon--star la la-star"></i></label>
                                        <input class="rating__input" name="rating" value="4" id="rating-4"
                                            type="radio">
                                        <label class="rating__label" for="rating-5"><i
                                                class="rating__icon rating__icon--star la la-star"></i></label>
                                        <input class="rating__input" name="rating" value="5" id="rating-5"
                                            type="radio">
                                    </div>
                                </div>
                                <div class="input-group">
                                    <textarea class="form-control form--control" placeholder="@lang('Your Review')" name="review" required></textarea>
                                    <label for="review" class="form-label textarea-input">@lang('Your Review')</label>
                                </div>

                                <input type="hidden" name="restaurant_id" value="{{ $restaurant->id }}">
                                <input type="hidden" name="user_id" value="{{ auth()->user()->id }}">

                                <button class="btn btn-location btn--base btn--md w-100 mt-3"
                                    type="submit">@lang('Submit Review')</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        @endauth

        <div id="otherFoodsModal" class="modal fade fade-in-scale" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('Alert!')</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <form action="{{ route('food.remove.other.restaurants.food') }}" method="POST"
                        id="otherFoodsModalForm">
                        @csrf
                        <div class="modal-body">
                            <input type="hidden" name="restaurant_id" value="{{ $restaurant->id }}">
                            <p class="question"> @lang('You currently have items from another restaurant in your cart. Adding items from this restaurant will replace those already selected. Would you like to proceed?') </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn--dark" data-bs-dismiss="modal">@lang('No')</button>
                            <button type="submit" class="btn btn--primary">@lang('Yes')</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endsection


    @push('script')
        <script>
            (function($) {
                "use strict";

                function showPrice(newPrice) {
                    var priceTemplate = "{{ showAmount(1) }}";
                    var updatedPrice = priceTemplate.replace("1.00", String(newPrice));
                    return updatedPrice;
                }

                class Food {
                    // Constructor function to initialize properties
                    constructor(foodJson) {
                        this.id = foodJson.id;
                        this.restaurant_id = foodJson.restaurant.id;
                        this.foodName = foodJson.name;
                        this.foodPrice = parseFloat(foodJson.price).toFixed(2);
                        this.image = foodJson.image;
                        this.description = foodJson.short_description;
                        this.variations = foodJson.variations;
                        this.addons = foodJson.addons;
                        $('.modal__product-qty__value').val(1);
                        $('#additional_notes').val('');
                        !this.variations.length ? $('.add-card-variation').hide() : $('.add-card-variation').show();
                        !this.addons.length ? $('.add-card-frequently').hide() : $('.add-card-frequently').show();
                    }

                    setRestaurantId() {
                        $('input[name="restaurant_id"]').val(this.restaurant_id);
                    }

                    setFoodId() {
                        $('input[name="food_id"]').val(this.id);
                    }

                    setImage() {
                        if (this.image) {
                            var imageUrl = '{{ asset('assets/images/food/image/') . '/' }}' + this.image;
                        } else {
                            var imageUrl = '{{ getImage('', getFileSize('food')) }}';
                        }
                        $('#food').attr('src', imageUrl);
                    }

                    setTitle() {
                        $('.add-card__item .title').html(
                            `${this.foodName} <span>@lang('Total') ${showPrice(this.foodPrice)}</span>`
                        );
                    }

                    setDescription() {
                        $('.add-card__item .desc').html(this.description);
                    }

                    setAddons() {
                        $('.add-card-frequently ul').empty();
                        var addonsHTML = '';
                        this.addons.forEach(addon => {
                            addonsHTML +=
                                `
                            <li>
                                <div class="custom--checkbox">
                                    <input type="checkbox" id="addon_${addon.id}" class="form-check-input addon-input" name="addon[]" value="${addon.id}" data-item-price="${(parseFloat(addon.price).toFixed(2))}">
                                    <label for="addon_${addon.id}">${addon.name}</label>
                                </div>
                                <div class="price">
                                    <span>${showPrice(parseFloat(addon.price).toFixed(2))}</span>
                                </div>
                            </li>

                            `
                        })
                        $('.add-card-frequently ul').html(addonsHTML);
                    }

                    setVariations() {
                        $('.add-card-variation .variations').empty();
                        var variationItems = '';
                        var variationHTML = '';
                        this.variations.forEach(variation => {

                            var itemsHTML = this.getVartationItems(variation);

                            variationHTML += `
                        <div class="variation">
                            <span>${variation.title}</span>
                            <ul>
                                ${itemsHTML}
                            </ul>
                        </div>
                        `;
                        });
                        $('.add-card-variation .variations').html(variationHTML);
                    }

                    getVartationItems(variation) {
                        var html = '';
                        variation.items.forEach(item => {
                            html +=
                                `
                        <li>
                            <div class="custom--radio">
                                <input type="radio" name="variation[${variation.id}]" class="form-check-input variation-input" id="variation_item_${item.id}" value="${item.id}" data-item-price="${(parseFloat(item.price).toFixed(2))}">
                                <label for="variation_item_${item.id}">${item.name}</label>
                            </div>
                            <div class="price">
                                <span>${showPrice(parseFloat(item.price).toFixed(2))}</span>
                            </div>
                        </li>

                        `
                        })
                        return html;

                    }

                    updateTotalPrice() {
                        var totalPrice = parseFloat(this.foodPrice);

                        $('input[name^="variation"]:checked').each(function() {
                            var itemPrice = parseFloat($(this).data('item-price'));
                            totalPrice += itemPrice;
                        });

                        $('input[name="addon[]"]:checked').each(function() {
                            var itemPrice = parseFloat($(this).data('item-price'));
                            totalPrice += itemPrice;
                        });

                        var quantity = parseInt($('input[name="quantity"]').val());
                        totalPrice *= quantity;

                        $('.add-card__item .title').html(
                            `${this.foodName} <span>@lang('Total') ${showPrice(totalPrice.toFixed(2))}</span>`
                        );

                    }

                } //class end

                $('#foodcart').on('show.bs.modal', function(e) {
                    var button = $(e.relatedTarget);
                    var foodData = button.closest('.popular-food__item').find('.foodData');
                    var foodJson = foodData.data('food');

                    var food = new Food(foodJson);
                    food.setRestaurantId();
                    food.setFoodId();
                    food.setImage();
                    food.setTitle();
                    food.setDescription();
                    food.setVariations();
                    food.setAddons();
                    food.updateTotalPrice();

                    //addListners
                    $(document).on('change', ".variation-input", function() {
                        food.updateTotalPrice();
                    });

                    $(document).on('change', ".addon-input", function() {
                        food.updateTotalPrice();
                    });

                    $(document).on('change', ".modal__product-qty__value", function() {
                        food.updateTotalPrice();
                    });

                }); //Modal End


                $(document).on('submit', "#otherFoodsModalForm", function(e) {
                    e.preventDefault();

                    var formData = new FormData($('#otherFoodsModalForm')[0]);
                    var url = $("#otherFoodsModalForm").attr("action");
                    var token = '{{ csrf_token() }}';
                    formData.append('_token', token);
                    $.ajax({
                        url: url,
                        method: 'POST',
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function(response) {
                            if (response.success) {
                                var modal = $('#otherFoodsModal');
                                modal.modal('hide');
                                $('#addToCart').click();
                            } else {
                                notify('error', response.message);
                            }
                        },
                        error: function(xhr, status, error) {
                            notify('error', error);
                        }
                    });
                });

                //Ajax
                $(document).on('click', "#addToCart", function() {
                    var btnAfterSubmit = `<div class="spinner-border"></div> @lang('Adding')...`;
                    var btnName = `@lang('Add to Cart')`;
                    var btn = $(this);
                    btn.html(btnAfterSubmit);
                    btn.attr('disabled', true);

                    //store
                    var formData = new FormData($('#addFoodModal')[0]);
                    var url = '{{ route('food.add.cart') }}';
                    var token = '{{ csrf_token() }}';
                    formData.append('_token', token);
                    $.ajax({
                        url: url,
                        method: 'POST',
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function(response) {
                            if (response.success == false && response.modal == true) {
                                var modal = $('#otherFoodsModal');
                                modal.modal('show');
                                $('.modal-backdrop').last().addClass('otherFoodsModalOverlay')
                            };
                            if (response.success == false && response.loginModal == true) {
                                $('#cartLoginModal').modal('show');
                                $('#cartLoginModal .modal-body p').text(response.message)
                                $('.modal-backdrop').last().addClass('otherFoodsModalOverlay')
                                btn.html(btnName);
                                btn.removeAttr('disabled');
                                return;
                            };
                            if (response.success) {
                                notify('success', `@lang('Added to cart')`);
                                btn.html(btnName);
                                btn.removeAttr('disabled');
                                $('#foodcart').modal('hide');
                                $('#cart').html(response.view)
                                $('.cart-btn-amount.cart-count').text(response.cart_count)
                            } else {
                                btn.html(btnName);
                                btn.removeAttr('disabled');
                                notify('error', response.message);
                            }
                        },
                        error: function(xhr, status, error) {
                            notify('error', error);
                            btn.html(btnName);
                            btn.removeAttr('disabled');
                        }
                    });
                });


            })(jQuery);
        </script>
        {{-- مودال البوب اب --}}
<div class="modal fade" id="statusModal" tabindex="-1" aria-labelledby="statusModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="statusModalLabel">تنبيه</h5>
      </div>
      <div class="modal-body" id="statusMessage">
        {{-- الرسالة هتتحط هنا --}}
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-warning" id="modalOkBtn" style="background-color: orange; border-color: orange; color: white;">حسناً</button>
      </div>
    </div>
  </div>
</div>

{{-- سكريبت جافاسكريبت --}}
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const providerStatus = @json($restaurant->provider);

    let message = '';
    if (providerStatus === 'مغلق') {
      message = 'المطعم مغلق حالياً، يرجى المحاولة لاحقاً.';
    } else if (providerStatus === 'مشغول') {
      message = 'المطعم مشغول حالياً، يرجى المحاولة مرة أخرى خلال قليل من الوقت.';
    }

    if(message) {
      document.getElementById('statusMessage').innerText = message;
      var statusModal = new bootstrap.Modal(document.getElementById('statusModal'));
      statusModal.show();

      // زرار حسنا
      document.getElementById('modalOkBtn').addEventListener('click', function () {
        statusModal.hide();
        window.location.href = 'https://aklooo.com/';
      });
    }
  });
</script>

    @endpush


    @push('style')
        <style>
            .your-cart-other {
                position: sticky;
                top: 120px;
            }

            @media (min-width: 1200px) {
                .your-cart-other .cross-btn {
                    display: none !important;
                }
            }

            .popular-food__item-style2 .popular-food__item-thumb a img {
                width: 124px;
                height: 124px;
                object-fit: cover;
            }
        </style>
    @endpush
