@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    <div class="py-70">
        <div class="container">
            <div class="row justify-content-center mt-2">
                <div class="col-lg-12 ">

                    <div class="dashboard-table">
                        <div class="dashbaord-table-header">
                            <h6 class="card-header__title mb-0">@lang('Logs') <i
                                    class="las la-file-invoice-dollar text--base"></i></h6>
                            <form class="search-form active">
                                <input type="text" name="search" class="form--control" value="{{ request()->search }}"
                                    placeholder="@lang('Search here')...">
                                <button type="submit" class="search-form__btn"><i class="las la-search"></i></button>
                            </form>
                        </div>

                        <table class="table table--responsive--xl">
                            <thead>
                                <tr>
                                    <th>@lang('Gateway | Transaction')</th>
                                    <th class="text-center">@lang('Initiated')</th>
                                    <th class="text-center">@lang('Amount')</th>
                                    <th class="text-center">@lang('Conversion')</th>
                                    <th class="text-center">@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($withdraws as $withdraw)
                                    <tr>
                                        <td>
                                            <div>
                                                <span class="fw-bold"><span class="text--base">
                                                        {{ __(@$withdraw->method->name) }}</span></span>
                                                <br>
                                                <small>{{ $withdraw->trx }}</small>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <div>
                                                {{ showDateTime($withdraw->created_at) }} <br>
                                                {{ diffForHumans($withdraw->created_at) }}
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <div>
                                                {{ __(gs()->cur_sym) }}{{ showAmount($withdraw->amount) }} - <span
                                                    class="text--danger" title="@lang('Charge')" data-bs-toggle="tooltip"
                                                    data-bs-placement="top"
                                                    data-bs-title="@lang('Charge')">{{ __(gs()->cur_sym) }}{{ showAmount($withdraw->charge) }}
                                                </span>
                                                <br>
                                                <strong title="@lang('Amount after charge')">
                                                    {{ showAmount($withdraw->amount - $withdraw->charge) }}
                                                    {{ __(gs()->cur_text) }}
                                                </strong>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <div>
                                                1 {{ __(gs()->cur_text) }} = {{ showAmount($withdraw->rate) }}
                                                {{ __($withdraw->currency) }}
                                                <br>
                                                <strong>{{ showAmount($withdraw->final_amount) }}
                                                    {{ __($withdraw->currency) }}</strong>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            @php echo $withdraw->statusBadge @endphp
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn--sm btn--base btn-outline--base detailBtn"
                                                data-user_data="{{ json_encode($withdraw->withdraw_information) }}"
                                                @if ($withdraw->status == Status::PAYMENT_REJECT) data-admin_feedback="{{ $withdraw->admin_feedback }}" @endif>
                                                <i class="las la-desktop"></i>
                                            </button>

                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted empty-message" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    @if ($withdraws->hasPages())
                        {{ paginateLinks($withdraws) }}
                    @endif
                </div>
            </div>
        </div>
    </div>



    {{-- APPROVE MODAL --}}
    <div id="detailModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Details')</h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <ul class="list-group userData">

                    </ul>
                    <div class="feedback"></div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');
                var userData = $(this).data('user_data');
                var html = ``;
                userData.forEach(element => {
                    if (element.type != 'file') {
                        html += `
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>${element.name}</span>
                            <span">${element.value}</span>
                        </li>`;
                    }
                });
                modal.find('.userData').html(html);

                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="my-3">
                            <strong>@lang('Admin Feedback')</strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }

                modal.find('.feedback').html(adminFeedback);

                modal.modal('show');
            });
        })(jQuery);
    </script>
@endpush
