@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    <div class="py-70">
        <div class="container">
            <div class="row justify-content-center mt-2">
                <div class="col-md-12">
                    <div class="dashboard-table">
                        <div class="dashbaord-table-header">
                            <h6 class="card-header__title mb-0">@lang('Support Tickets') <i class="las la-life-ring text--base"></i>
                            </h6>
                        </div>

                        <table class="table table--responsive--lg">
                            <thead>
                                <tr>
                                    <th>@lang('Subject')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Priority')</th>
                                    <th>@lang('Last Reply')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($supports as $support)
                                    <tr>
                                        <td>
                                            <a href="{{ route('restaurant.ticket.view', $support->ticket) }}"
                                                class="fw-bold">
                                                [@lang('Ticket')#{{ $support->ticket }}] {{ __($support->subject) }}
                                            </a>
                                        </td>
                                        <td>
                                            @php echo $support->statusBadge; @endphp
                                        </td>
                                        <td>
                                            @if ($support->priority == Status::PRIORITY_LOW)
                                                <span class="badge badge--dark">@lang('Low')</span>
                                            @elseif($support->priority == Status::PRIORITY_MEDIUM)
                                                <span class="badge badge--warning">@lang('Medium')</span>
                                            @elseif($support->priority == Status::PRIORITY_HIGH)
                                                <span class="badge badge--danger">@lang('High')</span>
                                            @endif
                                        </td>
                                        <td>{{ diffForHumans($support->last_reply) }}</td>
                                        <td>
                                            <a href="{{ route('restaurant.ticket.view', $support->ticket) }}"
                                                class="btn btn--sm btn-outline--base">
                                                <i class="las la-desktop"></i>
                                            </a>
                                        </td>

                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="100%" class="text-center empty-message">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    {{ paginateLinks($supports) }}
                </div>
            </div>
        </div>
    </div>
@endsection
